/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.Type;

public class DefaultLegacyTypesSupport
implements LegacyTypesSupport {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final Set<String> classesToMixInGroovyObject = this.readClassNames("converted-types.txt");
    private final Set<String> syntheticClasses = this.readClassNames("removed-types.txt");

    @Override
    public Set<String> getClassesToMixInGroovyObject() {
        return this.classesToMixInGroovyObject;
    }

    @Override
    public Set<String> getSyntheticClasses() {
        return this.syntheticClasses;
    }

    private Set<String> readClassNames(String resourceName) {
        HashSet<String> classNames = new HashSet<String>();
        URL resource = LegacyTypesSupport.class.getResource(resourceName);
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(resource.openStream()));){
            String line;
            while ((line = reader2.readLine()) != null) {
                classNames.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new GradleException("Could not load class names from '" + resource + "'.", e);
        }
        return classNames;
    }

    @Override
    public byte[] generateSyntheticClass(String name) {
        ClassWriter visitor = new ClassWriter(0);
        visitor.visit(51, 5633, name.replace('.', '/'), null, OBJECT_TYPE.getInternalName(), null);
        visitor.visitEnd();
        return visitor.toByteArray();
    }

    @Override
    public void injectEmptyInterfacesIntoClassLoader(ClassLoader classLoader) {
        try {
            for (String name : this.syntheticClasses) {
                byte[] bytes = this.generateSyntheticClass(name);
                ClassLoaderUtils.define(classLoader, name, bytes);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not inject synthetic classes.", e);
        }
    }
}

