/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildInclusionCoordinator;
import org.gradle.internal.reflect.Instantiator;

public class DefaultBuildIncluder
implements BuildIncluder {
    private final BuildStateRegistry buildRegistry;
    private final BuildInclusionCoordinator coordinator;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;
    private final GradleInternal gradle;
    private final List<BuildDefinition> pluginBuildDefinitions = new ArrayList<BuildDefinition>();

    public DefaultBuildIncluder(BuildStateRegistry buildRegistry, BuildInclusionCoordinator coordinator, PublicBuildPath publicBuildPath, Instantiator instantiator2, GradleInternal gradle) {
        this.buildRegistry = buildRegistry;
        this.coordinator = coordinator;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator2;
        this.gradle = gradle;
    }

    @Override
    public CompositeBuildParticipantBuildState includeBuild(IncludedBuildSpec includedBuildSpec) {
        RootBuildState rootBuild = this.buildRegistry.getRootBuild();
        if (includedBuildSpec.rootDir.equals(rootBuild.getBuildRootDir())) {
            this.coordinator.prepareRootBuildForInclusion();
            return rootBuild;
        }
        BuildDefinition buildDefinition = this.toBuildDefinition(includedBuildSpec, this.gradle);
        IncludedBuildState build2 = this.buildRegistry.addIncludedBuild(buildDefinition);
        this.coordinator.prepareForInclusion(build2, buildDefinition.isPluginBuild());
        return build2;
    }

    @Override
    public void registerPluginBuild(IncludedBuildSpec includedBuildSpec) {
        this.pluginBuildDefinitions.add(this.toBuildDefinition(includedBuildSpec, this.gradle));
    }

    @Override
    public Collection<IncludedBuildState> getRegisteredPluginBuilds() {
        return this.pluginBuildDefinitions.stream().map(buildDefinition -> {
            IncludedBuildState build2 = this.buildRegistry.addIncludedBuild((BuildDefinition)buildDefinition);
            this.coordinator.prepareForInclusion(build2, true);
            return build2;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<IncludedBuildState> getIncludedBuildsForPluginResolution() {
        BuildState thisBuild = this.gradle.getOwner();
        return this.buildRegistry.getIncludedBuilds().stream().filter(build2 -> build2 != thisBuild && !build2.isImplicitBuild() && !build2.isPluginBuild()).collect(Collectors.toList());
    }

    @Override
    public void prepareForPluginResolution(IncludedBuildState build2) {
        this.coordinator.prepareForPluginResolution(build2);
    }

    private BuildDefinition toBuildDefinition(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        gradle.getOwner().assertCanAdd(includedBuildSpec);
        return includedBuildSpec.toBuildDefinition(gradle.getStartParameter(), this.publicBuildPath, this.instantiator);
    }
}

