/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class IgnoredPathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final IgnoredPathFingerprintingStrategy DEFAULT = new IgnoredPathFingerprintingStrategy();
    public static final String IDENTIFIER = "IGNORED_PATH";
    public static final String IGNORED_PATH = "";
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public IgnoredPathFingerprintingStrategy(FileSystemLocationSnapshotHasher normalizedContentHasher) {
        super(IDENTIFIER, normalizedContentHasher);
        this.normalizedContentHasher = normalizedContentHasher;
    }

    private IgnoredPathFingerprintingStrategy() {
        this(FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        roots.accept(new MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor(){

            @Override
            public void visitAcceptedEntry(FileSystemLocationSnapshot snapshot, boolean isRoot) {
                HashCode normalizedContentHash;
                if (snapshot.getType() != FileType.Directory && (normalizedContentHash = IgnoredPathFingerprintingStrategy.this.getNormalizedContentHash(snapshot, IgnoredPathFingerprintingStrategy.this.normalizedContentHasher)) != null) {
                    builder.put((Object)snapshot.getAbsolutePath(), (Object)IgnoredPathFileSystemLocationFingerprint.create(snapshot.getType(), normalizedContentHash));
                }
            }
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

