/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class AbstractProgressLoggingHandler {
    protected ResourceOperation createResourceOperation(BuildOperationContext context, ResourceOperation.Type operationType) {
        return new ResourceOperation(context, operationType);
    }

    protected static class ProgressLoggingInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final ResourceOperation resourceOperation;

        public ProgressLoggingInputStream(InputStream inputStream, ResourceOperation resourceOperation) {
            this.inputStream = inputStream;
            this.resourceOperation = resourceOperation;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Reading from a remote resource should be buffered.");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read2 = this.inputStream.read(b, off, len);
            if (read2 > 0) {
                this.doLogProgress(read2);
            }
            return read2;
        }

        private void doLogProgress(long numberOfBytes) {
            this.resourceOperation.logProcessedBytes(numberOfBytes);
        }
    }

    protected static class LocationDetails {
        private final URI location;

        LocationDetails(URI location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location.toASCIIString();
        }
    }
}

