/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.gradle.api.NonNullApi;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@NonNullApi
public class SystemDefaultSSLContextFactory {
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final Logger LOGGER = Logging.getLogger(SystemDefaultSSLContextFactory.class);

    static SSLContext create() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SystemDefaultSSLContextFactory.getKeyManagers(), SystemDefaultSSLContextFactory.getTrustManagers(), null);
        return context;
    }

    private static KeyManager[] getKeyManagers() throws Exception {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore", "");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
        String keyStorePasswordString = System.getProperty("javax.net.ssl.keyStorePassword", "");
        if (P11KEYSTORE.equals(keyStoreType) && !NONE.equals(keyStorePath)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        char[] keystorePassword = null;
        if (!keyStorePasswordString.isEmpty()) {
            keystorePassword = keyStorePasswordString.toCharArray();
        }
        KeyStore keyStore2 = SystemDefaultSSLContextFactory.loadKeyStore(keyStorePath, keyStoreType, keyStoreProvider, keystorePassword, true);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (P11KEYSTORE.equals(keyStoreType)) {
            keyManagerFactory.init(keyStore2, null);
        } else {
            keyManagerFactory.init(keyStore2, keystorePassword);
        }
        return keyManagerFactory.getKeyManagers();
    }

    @Nullable
    private static KeyStore loadKeyStore(String keyStorePath, String keyStoreType, String keyStoreProvider, @Nullable char[] keyStorePassword, boolean errorOnMissingFile) throws Exception {
        KeyStore keyStore2;
        block10: {
            if (keyStoreType.isEmpty()) {
                return null;
            }
            keyStore2 = keyStoreProvider.isEmpty() ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            if (!keyStorePath.isEmpty() && !NONE.equals(keyStorePath)) {
                try (FileInputStream fis = new FileInputStream(keyStorePath);){
                    keyStore2.load(fis, keyStorePassword);
                    break block10;
                }
                catch (FileNotFoundException e) {
                    if (errorOnMissingFile) {
                        throw e;
                    }
                    return null;
                }
            }
            keyStore2.load(null, keyStorePassword);
        }
        return keyStore2;
    }

    private static String getDefaultSecurityPath() {
        return System.getProperty("java.home") + File.separator + "lib" + File.separator + "security";
    }

    private static String getDefaultTrustStore() {
        return SystemDefaultSSLContextFactory.getDefaultSecurityPath() + File.separator + "cacerts";
    }

    private static String getDefaultJsseTrustStore() {
        return SystemDefaultSSLContextFactory.getDefaultSecurityPath() + File.separator + "jssecacerts";
    }

    private static TrustManager[] getTrustManagers() throws Exception {
        String storePath = System.getProperty("javax.net.ssl.trustStore", SystemDefaultSSLContextFactory.getDefaultJsseTrustStore());
        String storeType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
        String storeProvider = System.getProperty("javax.net.ssl.trustStoreProvider", "");
        String storePasswordString = System.getProperty("javax.net.ssl.trustStorePassword", "");
        KeyStore keyStore2 = null;
        if (!NONE.equals(storePath)) {
            String[] fileNames;
            for (String fileName : fileNames = new String[]{storePath, SystemDefaultSSLContextFactory.getDefaultTrustStore()}) {
                File candidate = new File(fileName);
                if (candidate.isFile() && candidate.canRead()) {
                    storePath = fileName;
                    break;
                }
                if (fileName.equals(SystemDefaultSSLContextFactory.getDefaultJsseTrustStore())) continue;
                LOGGER.warn("Trust store file {} does not exist or is not readable. This may lead to SSL connection failures.", fileName);
            }
            char[] storePassword = null;
            if (!storePasswordString.isEmpty()) {
                storePassword = storePasswordString.toCharArray();
            }
            keyStore2 = SystemDefaultSSLContextFactory.loadKeyStore(storePath, storeType, storeProvider, storePassword, false);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore2);
        return trustManagerFactory.getTrustManagers();
    }
}

