/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scopeids;

import java.io.File;
import org.gradle.cache.ObjectHolder;
import org.gradle.cache.scopes.BuildTreeScopedCacheBuilderFactory;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.cache.scopes.ScopedCacheBuilderFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.scopeids.PersistentScopeIdLoader;
import org.gradle.internal.scopeids.PersistentScopeIdStoreFactory;
import org.gradle.internal.scopeids.id.UserScopeId;
import org.gradle.internal.scopeids.id.WorkspaceScopeId;

class DefaultPersistentScopeIdLoader
implements PersistentScopeIdLoader {
    private static final String USER_ID_FILENAME = "user-id.txt";
    private static final String WORKSPACE_ID_FILENAME = "workspace-id.txt";
    private final Factory<UniqueId> generator;
    private final PersistentScopeIdStoreFactory storeFactory;
    private final GlobalScopedCacheBuilderFactory globalScopedcacheBuilderFactory;
    private final BuildTreeScopedCacheBuilderFactory buildTreeScopedCacheBuilderFactory;

    DefaultPersistentScopeIdLoader(GlobalScopedCacheBuilderFactory globalScopedcacheBuilderFactory, BuildTreeScopedCacheBuilderFactory buildTreeScopedCacheBuilderFactory, PersistentScopeIdStoreFactory storeFactory, Factory<UniqueId> generator) {
        this.globalScopedcacheBuilderFactory = globalScopedcacheBuilderFactory;
        this.buildTreeScopedCacheBuilderFactory = buildTreeScopedCacheBuilderFactory;
        this.generator = generator;
        this.storeFactory = storeFactory;
    }

    @Override
    public UserScopeId getUser() {
        UniqueId uniqueId = this.get(new ScopeParams(this.userScopeCacheScopeMarker(), USER_ID_FILENAME, "User ID"));
        return new UserScopeId(uniqueId);
    }

    @Override
    public WorkspaceScopeId getWorkspace() {
        UniqueId uniqueId = this.get(new ScopeParams(this.workspaceScopeCacheScopeMarker(), WORKSPACE_ID_FILENAME, "Workspace ID"));
        return new WorkspaceScopeId(uniqueId);
    }

    private GlobalScopedCacheBuilderFactory userScopeCacheScopeMarker() {
        return this.globalScopedcacheBuilderFactory;
    }

    private BuildTreeScopedCacheBuilderFactory workspaceScopeCacheScopeMarker() {
        return this.buildTreeScopedCacheBuilderFactory;
    }

    private UniqueId get(ScopeParams params) {
        ObjectHolder<UniqueId> store2 = this.store(params);
        return store2.maybeUpdate(new ObjectHolder.UpdateAction<UniqueId>(){

            @Override
            public UniqueId update(UniqueId oldValue) {
                if (oldValue == null) {
                    return (UniqueId)DefaultPersistentScopeIdLoader.this.generator.create();
                }
                return oldValue;
            }
        });
    }

    private ObjectHolder<UniqueId> store(ScopeParams params) {
        File file = params.cacheBuilderFactory.baseDirForCrossVersionCache(params.fileName);
        return this.storeFactory.create(file, params.description);
    }

    private static class ScopeParams {
        private final ScopedCacheBuilderFactory cacheBuilderFactory;
        private final String fileName;
        private final String description;

        private ScopeParams(ScopedCacheBuilderFactory cacheBuilderFactory, String fileName, String description) {
            this.cacheBuilderFactory = cacheBuilderFactory;
            this.fileName = fileName;
            this.description = description;
        }
    }
}

