/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.ComponentWithTargetMachines;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.internal.DefaultTargetMachineFactory;
import org.gradle.nativeplatform.test.TestSuiteComponent;
import org.gradle.testing.base.plugins.TestingBasePlugin;

@Incubating
public abstract class NativeTestingBasePlugin
implements Plugin<Project> {
    private final TargetMachineFactory targetMachineFactory;
    private static final String TEST_TASK_NAME = "test";
    private static final String TEST_COMPONENT_NAME = "test";

    @Inject
    public NativeTestingBasePlugin(TargetMachineFactory targetMachineFactory) {
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(TestingBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        NamedDomainObjectProvider test = tasks.register("test", task -> task.dependsOn(() -> {
            TestSuiteComponent unitTestSuite = (TestSuiteComponent)project.getComponents().withType(TestSuiteComponent.class).findByName("test");
            if (unitTestSuite != null && unitTestSuite.getTestBinary().isPresent()) {
                return unitTestSuite.getTestBinary().get().getRunTask();
            }
            return null;
        }));
        project.getComponents().withType(TestSuiteComponent.class, arg_0 -> this.lambda$apply$5((TaskProvider)test, project, arg_0));
        tasks.named("check", arg_0 -> NativeTestingBasePlugin.lambda$apply$6((TaskProvider)test, arg_0));
    }

    private static /* synthetic */ void lambda$apply$6(TaskProvider test, Task task) {
        task.dependsOn(test);
    }

    private /* synthetic */ void lambda$apply$5(TaskProvider test, Project project, TestSuiteComponent testSuiteComponent) {
        if (testSuiteComponent instanceof ComponentWithTargetMachines) {
            ComponentWithTargetMachines componentWithTargetMachines = (ComponentWithTargetMachines)((Object)testSuiteComponent);
            if ("test".equals(testSuiteComponent.getName())) {
                test.configure(task -> task.dependsOn(() -> {
                    TargetMachine currentHost = ((DefaultTargetMachineFactory)this.targetMachineFactory).host();
                    boolean targetsCurrentMachine = ((Set)componentWithTargetMachines.getTargetMachines().get()).stream().anyMatch(targetMachine -> currentHost.getOperatingSystemFamily().equals(targetMachine.getOperatingSystemFamily()));
                    if (!targetsCurrentMachine) {
                        task.getLogger().warn("'" + testSuiteComponent.getName() + "' component in project '" + project.getPath() + "' does not target this operating system.");
                    }
                    return Collections.emptyList();
                }));
            }
        }
    }
}

