/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppMetadataProvider;
import org.gradle.util.internal.VersionNumber;

public class DefaultVisualCppMetadataProvider
implements VisualCppMetadataProvider {
    private static final String VS2017_METADATA_FILE_PATH = "VC/Auxiliary/Build/Microsoft.VCToolsVersion.default.txt";
    private static final String VS2017_COMPILER_PATH_PREFIX = "VC/Tools/MSVC";
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_VC = "Microsoft\\VisualStudio\\SxS\\VC7";
    private static final Logger LOGGER = Logging.getLogger(DefaultVisualCppMetadataProvider.class);
    private final WindowsRegistry windowsRegistry;

    public DefaultVisualCppMetadataProvider(WindowsRegistry windowsRegistry) {
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    public VisualCppInstallCandidate getVisualCppFromRegistry(String version) {
        for (String baseKey : REGISTRY_BASEPATHS) {
            try {
                File visualCppDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC, version));
                return new DefaultVisualCppMetadata(visualCppDir, VersionNumber.parse(version));
            }
            catch (MissingRegistryEntryException missingRegistryEntryException) {
            }
        }
        LOGGER.debug("No Windows registry values found for version " + version);
        return null;
    }

    @Override
    public VisualCppInstallCandidate getVisualCppFromMetadataFile(File installDir) {
        File msvcVersionFile = new File(installDir, VS2017_METADATA_FILE_PATH);
        if (!msvcVersionFile.exists() || !msvcVersionFile.isFile()) {
            LOGGER.debug("The MSVC version file at {} either does not exist or is not a file.  Cannot determine the MSVC version for this installation.", msvcVersionFile.getAbsolutePath());
            return null;
        }
        try {
            String versionString = FileUtils.readFileToString((File)msvcVersionFile, (Charset)StandardCharsets.UTF_8).trim();
            File visualCppDir = new File(installDir, "VC/Tools/MSVC/" + versionString);
            return new DefaultVisualCppMetadata(visualCppDir, VersionNumber.parse(versionString));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static class DefaultVisualCppMetadata
    implements VisualCppInstallCandidate {
        private final File visualCppDir;
        private final VersionNumber version;

        public DefaultVisualCppMetadata(File visualCppDir, VersionNumber version) {
            this.visualCppDir = visualCppDir;
            this.version = version;
        }

        @Override
        public File getVisualCppDir() {
            return this.visualCppDir;
        }

        @Override
        public VersionNumber getVersion() {
            return this.version;
        }
    }
}

