/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.util.Arrays;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;

public class Fingerprint {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private final byte[] fingerprint;
    private final int hashCode;

    public static Fingerprint of(PGPPublicKey key) {
        return new Fingerprint(key.getFingerprint());
    }

    public static Fingerprint wrap(byte[] fingerprint) {
        return new Fingerprint(fingerprint);
    }

    public static Fingerprint fromString(String hexString) {
        int length = hexString.length();
        if (length % 2 == 1) {
            throw new IllegalStateException("Unexpected hex string length: " + length);
        }
        int len = length / 2;
        byte[] result2 = new byte[len];
        for (int i = 0; i < len; ++i) {
            int hi = Fingerprint.decode(hexString.charAt(2 * i)) << 4;
            int lo = Fingerprint.decode(hexString.charAt(2 * i + 1));
            result2[i] = (byte)(hi + lo);
        }
        return new Fingerprint(result2);
    }

    private static int decode(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal character: " + ch);
    }

    private Fingerprint(byte[] fingerprint) {
        this.fingerprint = fingerprint;
        this.hashCode = Arrays.hashCode(fingerprint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 * this.fingerprint.length);
        for (byte b : this.fingerprint) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fingerprint that = (Fingerprint)o;
        return Arrays.equals(this.fingerprint, that.fingerprint);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] getBytes() {
        return this.fingerprint;
    }
}

