/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core;

import org.jetbrains.annotations.NotNull;

public final class Color {
    private final int value;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public Color(int rgb) {
        this(rgb, false);
    }

    public Color(int rgba, boolean hasAlpha) {
        this.value = hasAlpha ? rgba : 0xFF000000 | rgba;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    @NotNull
    public String toXParseColor() {
        return "rgb:" + this.toHexString16();
    }

    @NotNull
    private String toHexString16() {
        String red = this.padStart(Integer.toHexString(this.getRed() * 257), 4, '0');
        String green = this.padStart(Integer.toHexString(this.getGreen() * 257), 4, '0');
        String blue = this.padStart(Integer.toHexString(this.getBlue() * 257), 4, '0');
        return red + "/" + green + "/" + blue;
    }

    @NotNull
    private String padStart(@NotNull String str, int totalLength, char ch) {
        return Character.toString(ch).repeat(Math.max(0, totalLength - str.length())) + str;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Color && ((Color)o).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ", alpha=" + this.getAlpha() + "]";
    }
}

