/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.WinSize;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.NamedPipe;
import com.pty4j.windows.WinPtyException;
import com.pty4j.windows.WindowsVersion;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinPty {
    private static final Logger LOG = LoggerFactory.getLogger(WinPty.class);
    private static final boolean DEFAULT_MIN_INITIAL_TERMINAL_WINDOW_HEIGHT = !Boolean.getBoolean("disable.minimal.initial.terminal.window.height");
    private Pointer myWinpty;
    private WinNT.HANDLE myProcess;
    private NamedPipe myConinPipe;
    private NamedPipe myConoutPipe;
    private NamedPipe myConerrPipe;
    private boolean myChildExited = false;
    private int myStatus = -1;
    private boolean myClosed = false;
    private WinSize myLastWinSize;
    private int openInputStreamCount = 0;
    static final Kern32 KERNEL32 = (Kern32)Native.loadLibrary((String)"kernel32", Kern32.class);
    private static WinPtyLib INSTANCE = (WinPtyLib)Native.loadLibrary((String)WinPty.getLibraryPath(), WinPtyLib.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WinPty(@NotNull String cmdline, @Nullable String cwd, @NotNull String env, boolean consoleMode, @Nullable Integer initialColumns, @Nullable Integer initialRows, boolean enableAnsiColor) throws WinPtyException, IOException {
        int cols = initialColumns != null ? initialColumns : Integer.getInteger("win.pty.cols", 80);
        int rows = this.getInitialRows(initialRows);
        IntByReference errCode = new IntByReference();
        PointerByReference errPtr = new PointerByReference(null);
        Pointer agentCfg = null;
        Pointer spawnCfg = null;
        Pointer winpty = null;
        WinNT.HANDLEByReference processHandle = new WinNT.HANDLEByReference();
        NamedPipe coninPipe = null;
        NamedPipe conoutPipe = null;
        NamedPipe conerrPipe = null;
        try {
            long agentFlags = 0L;
            if (consoleMode) {
                agentFlags = 3L;
                if (enableAnsiColor) {
                    agentFlags |= 4L;
                }
            }
            if ((agentCfg = INSTANCE.winpty_config_new(agentFlags, null)) == null) {
                throw new WinPtyException("winpty agent cfg is null");
            }
            INSTANCE.winpty_config_set_initial_size(agentCfg, cols, rows);
            this.myLastWinSize = new WinSize(cols, rows);
            winpty = INSTANCE.winpty_open(agentCfg, errPtr);
            if (winpty == null) {
                WString errMsg = INSTANCE.winpty_error_msg(errPtr.getValue());
                Object errorMessage = errMsg.toString();
                if ("ConnectNamedPipe failed: Windows error 232".equals(errorMessage)) {
                    errorMessage = (String)errorMessage + "\n" + WinPty.suggestFixForError232();
                }
                throw new WinPtyException("Error starting winpty: " + (String)errorMessage);
            }
            coninPipe = NamedPipe.connectToServer(INSTANCE.winpty_conin_name(winpty).toString(), 0x40000000);
            conoutPipe = NamedPipe.connectToServer(INSTANCE.winpty_conout_name(winpty).toString(), Integer.MIN_VALUE);
            if (consoleMode) {
                conerrPipe = NamedPipe.connectToServer(INSTANCE.winpty_conerr_name(winpty).toString(), Integer.MIN_VALUE);
            }
            for (int i = 0; i < 5; ++i) {
                boolean result = INSTANCE.winpty_set_size(winpty, cols, rows, null);
                if (!result) {
                    LOG.info("Cannot resize to workaround extra newlines issue");
                    break;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((spawnCfg = INSTANCE.winpty_spawn_config_new(3L, null, WinPty.toWString(cmdline), WinPty.toWString(cwd), WinPty.toWString(env), null)) == null) {
                throw new WinPtyException("winpty spawn cfg is null");
            }
            if (!INSTANCE.winpty_spawn(winpty, spawnCfg, processHandle, null, errCode, errPtr)) {
                WString errMsg = INSTANCE.winpty_error_msg(errPtr.getValue());
                throw new WinPtyException("Error running process: " + errMsg.toString() + ". Code " + errCode.getValue());
            }
            this.myWinpty = winpty;
            this.myProcess = processHandle.getValue();
            this.myConinPipe = coninPipe;
            this.myConoutPipe = conoutPipe;
            this.myConerrPipe = conerrPipe;
            this.openInputStreamCount = consoleMode ? 2 : 1;
            WaitForExitThread waitForExit = new WaitForExitThread();
            waitForExit.setDaemon(true);
            waitForExit.start();
            winpty = null;
            processHandle.setValue(null);
            conerrPipe = null;
            conoutPipe = null;
            coninPipe = null;
            INSTANCE.winpty_error_free(errPtr.getValue());
            INSTANCE.winpty_config_free(agentCfg);
            INSTANCE.winpty_spawn_config_free(spawnCfg);
            INSTANCE.winpty_free(winpty);
        }
        catch (Throwable throwable) {
            INSTANCE.winpty_error_free(errPtr.getValue());
            INSTANCE.winpty_config_free(agentCfg);
            INSTANCE.winpty_spawn_config_free(spawnCfg);
            INSTANCE.winpty_free(winpty);
            if (processHandle.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(processHandle.getValue());
            }
            WinPty.closeNamedPipeQuietly(coninPipe);
            WinPty.closeNamedPipeQuietly(conoutPipe);
            WinPty.closeNamedPipeQuietly(conerrPipe);
            throw throwable;
        }
        if (processHandle.getValue() != null) {
            Kernel32.INSTANCE.CloseHandle(processHandle.getValue());
        }
        WinPty.closeNamedPipeQuietly(coninPipe);
        WinPty.closeNamedPipeQuietly(conoutPipe);
        WinPty.closeNamedPipeQuietly(conerrPipe);
    }

    @NotNull
    private static String suggestFixForError232() {
        try {
            File dllFile = new File(WinPty.getLibraryPath());
            File exeFile = new File(dllFile.getParentFile(), "winpty-agent.exe");
            return "This error can occur due to antivirus blocking winpty from creating a pty. Please exclude the following files in your antivirus:\n - " + exeFile.getAbsolutePath() + "\n - " + dllFile.getAbsolutePath();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private int getInitialRows(@Nullable Integer initialRows) {
        if (initialRows != null) {
            return initialRows;
        }
        Integer rows = Integer.getInteger("win.pty.rows");
        if (rows != null) {
            return rows;
        }
        try {
            WindowsVersion.getVersion();
            return DEFAULT_MIN_INITIAL_TERMINAL_WINDOW_HEIGHT ? 1 : 25;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 25;
        }
    }

    private static void closeNamedPipeQuietly(NamedPipe pipe) {
        try {
            if (pipe != null) {
                pipe.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static WString toWString(String string) {
        return string == null ? null : new WString(string);
    }

    synchronized void setWinSize(@NotNull WinSize winSize) throws IOException {
        if (this.myClosed) {
            throw new IOException("Unable to set window size: closed=" + this.myClosed + ", winSize=" + winSize);
        }
        boolean result = INSTANCE.winpty_set_size(this.myWinpty, winSize.getColumns(), winSize.getRows(), null);
        if (result) {
            this.myLastWinSize = new WinSize(winSize.getColumns(), winSize.getRows());
        }
    }

    @NotNull
    synchronized WinSize getWinSize() throws IOException {
        WinSize lastWinSize = this.myLastWinSize;
        if (this.myClosed || lastWinSize == null) {
            throw new IOException("Unable to get window size: closed=" + this.myClosed + ", lastWinSize=" + lastWinSize);
        }
        return new WinSize(lastWinSize.getColumns(), lastWinSize.getRows());
    }

    synchronized void decrementOpenInputStreamCount() {
        --this.openInputStreamCount;
        if (this.openInputStreamCount == 0) {
            this.close();
        }
    }

    synchronized void close() {
        if (this.myClosed) {
            return;
        }
        INSTANCE.winpty_free(this.myWinpty);
        this.myWinpty = null;
        this.myClosed = true;
        this.closeUnusedProcessHandle();
    }

    private synchronized void closeUnusedProcessHandle() {
        if (this.myClosed && this.myChildExited && this.myProcess != null) {
            Kernel32.INSTANCE.CloseHandle(this.myProcess);
            this.myProcess = null;
        }
    }

    synchronized boolean isRunning() {
        return !this.myChildExited;
    }

    synchronized int waitFor() throws InterruptedException {
        while (!this.myChildExited) {
            this.wait();
        }
        return this.myStatus;
    }

    synchronized int getChildProcessId() {
        if (this.myClosed) {
            return -1;
        }
        return Kernel32.INSTANCE.GetProcessId(this.myProcess);
    }

    synchronized int exitValue() {
        if (!this.myChildExited) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.myStatus;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    NamedPipe getInputPipe() {
        return this.myConoutPipe;
    }

    NamedPipe getOutputPipe() {
        return this.myConinPipe;
    }

    NamedPipe getErrorPipe() {
        return this.myConerrPipe;
    }

    @Nullable
    String getWorkingDirectory() throws IOException {
        if (this.myClosed) {
            return null;
        }
        int bufferLength = 1024;
        Memory buffer = new Memory((long)(Native.WCHAR_SIZE * bufferLength));
        PointerByReference errPtr = new PointerByReference();
        try {
            int result = INSTANCE.winpty_get_current_directory(this.myWinpty, bufferLength, (Pointer)buffer, errPtr);
            if (result > 0) {
                String string = buffer.getWideString(0L);
                return string;
            }
            WString message = INSTANCE.winpty_error_msg(errPtr.getValue());
            int code = INSTANCE.winpty_error_code(errPtr.getValue());
            throw new IOException("winpty_get_current_directory failed, code: " + code + ", message: " + message);
        }
        finally {
            INSTANCE.winpty_error_free(errPtr.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getConsoleProcessList() throws IOException {
        if (this.myClosed) {
            return 0;
        }
        int MAX_COUNT = 64;
        Memory buffer = new Memory((long)(Native.LONG_SIZE * MAX_COUNT));
        PointerByReference errPtr = new PointerByReference();
        try {
            int actualProcessCount = INSTANCE.winpty_get_console_process_list(this.myWinpty, (Pointer)buffer, MAX_COUNT, errPtr);
            if (actualProcessCount == 0) {
                WString message = INSTANCE.winpty_error_msg(errPtr.getValue());
                int code = INSTANCE.winpty_error_code(errPtr.getValue());
                throw new IOException("winpty_get_console_process_list failed, code: " + code + ", message: " + message);
            }
            int n = actualProcessCount;
            return n;
        }
        finally {
            INSTANCE.winpty_error_free(errPtr.getValue());
        }
    }

    private static String getLibraryPath() {
        try {
            return PtyUtil.resolveNativeLibrary().getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't detect jar containing folder", e);
        }
    }

    private static interface WinPtyLib
    extends Library {
        public static final long WINPTY_FLAG_CONERR = 1L;
        public static final long WINPTY_FLAG_PLAIN_OUTPUT = 2L;
        public static final long WINPTY_FLAG_COLOR_ESCAPES = 4L;
        public static final long WINPTY_SPAWN_FLAG_AUTO_SHUTDOWN = 1L;
        public static final long WINPTY_SPAWN_FLAG_EXIT_AFTER_SHUTDOWN = 2L;

        public int winpty_error_code(Pointer var1);

        public WString winpty_error_msg(Pointer var1);

        public void winpty_error_free(Pointer var1);

        public Pointer winpty_config_new(long var1, PointerByReference var3);

        public void winpty_config_free(Pointer var1);

        public void winpty_config_set_initial_size(Pointer var1, int var2, int var3);

        public Pointer winpty_open(Pointer var1, PointerByReference var2);

        public WString winpty_conin_name(Pointer var1);

        public WString winpty_conout_name(Pointer var1);

        public WString winpty_conerr_name(Pointer var1);

        public Pointer winpty_spawn_config_new(long var1, WString var3, WString var4, WString var5, WString var6, PointerByReference var7);

        public void winpty_spawn_config_free(Pointer var1);

        public boolean winpty_spawn(Pointer var1, Pointer var2, WinNT.HANDLEByReference var3, WinNT.HANDLEByReference var4, IntByReference var5, PointerByReference var6);

        public boolean winpty_set_size(Pointer var1, int var2, int var3, PointerByReference var4);

        public int winpty_get_console_process_list(Pointer var1, Pointer var2, int var3, PointerByReference var4);

        public int winpty_get_current_directory(Pointer var1, int var2, Pointer var3, PointerByReference var4);

        public void winpty_free(Pointer var1);
    }

    static interface Kern32
    extends Library {
        public boolean PeekNamedPipe(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, IntByReference var5, IntByReference var6);

        public boolean ReadFile(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, Pointer var5);

        public boolean WriteFile(WinNT.HANDLE var1, Pointer var2, int var3, IntByReference var4, Pointer var5);

        public boolean GetOverlappedResult(WinNT.HANDLE var1, Pointer var2, IntByReference var3, boolean var4);

        public WinNT.HANDLE CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, WinBase.SECURITY_ATTRIBUTES var8);

        public boolean ConnectNamedPipe(WinNT.HANDLE var1, WinBase.OVERLAPPED var2);

        public boolean CloseHandle(WinNT.HANDLE var1);

        public WinNT.HANDLE CreateEventA(WinBase.SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4);

        public int GetLastError();

        public int WaitForSingleObject(WinNT.HANDLE var1, int var2);

        public boolean CancelIo(WinNT.HANDLE var1);

        public int GetCurrentProcessId();
    }

    private class WaitForExitThread
    extends Thread {
        private IntByReference myStatusByRef = new IntByReference(-1);

        private WaitForExitThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Kernel32.INSTANCE.WaitForSingleObject(WinPty.this.myProcess, -1);
            Kernel32.INSTANCE.GetExitCodeProcess(WinPty.this.myProcess, this.myStatusByRef);
            WinPty winPty = WinPty.this;
            synchronized (winPty) {
                WinPty.this.myChildExited = true;
                WinPty.this.myStatus = this.myStatusByRef.getValue();
                WinPty.this.closeUnusedProcessHandle();
                WinPty.this.notifyAll();
            }
        }
    }
}

