/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.report.BuildScenarioResult;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.Sample;
import org.gradle.profiler.result.SampleProvider;

public class BuildScenarioResultImpl<T extends BuildInvocationResult>
implements BuildScenarioResult<T>,
Consumer<T> {
    private final ScenarioDefinition scenario;
    private final SampleProvider<T> sampleProvider;
    private final List<T> results = new ArrayList<T>();

    public BuildScenarioResultImpl(ScenarioDefinition scenario, SampleProvider<T> samplesProvider) {
        this.scenario = scenario;
        this.sampleProvider = samplesProvider;
    }

    @Override
    public void accept(T buildInvocationResult) {
        this.results.add(buildInvocationResult);
    }

    @Override
    public ScenarioDefinition getScenarioDefinition() {
        return this.scenario;
    }

    @Override
    public List<Sample<? super T>> getSamples() {
        return this.sampleProvider.get(this.results);
    }

    @Override
    public List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

