/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.gradle.profiler.GradleArgsCalculator;

public abstract class GeneratedInitScript
implements GradleArgsCalculator {
    private final File initScript;
    private boolean generated;

    public GeneratedInitScript() {
        try {
            this.initScript = File.createTempFile("gradleProfiler" + this.getClass().getSimpleName(), ".gradle").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.initScript.deleteOnExit();
    }

    protected abstract void writeContents(PrintWriter var1);

    private void maybeGenerateInitScript() {
        if (this.generated) {
            return;
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.initScript));){
            this.writeContents(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.generated = true;
    }

    @Override
    public void calculateGradleArgs(List<String> gradleArgs) {
        this.maybeGenerateInitScript();
        gradleArgs.add("-I");
        gradleArgs.add(this.initScript.getAbsolutePath());
    }
}

