/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.gradle;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.Logging;
import org.gradle.profiler.buildops.BuildOperationExecutionData;
import org.gradle.profiler.buildops.BuildOperationInstrumentation;
import org.gradle.profiler.gradle.GradleBuildInvocationResult;
import org.gradle.profiler.instrument.PidInstrumentation;
import org.gradle.profiler.result.BuildActionResult;

public class BuildUnderTestInvoker {
    private final List<String> jvmArgs;
    private final List<String> gradleArgs;
    private final GradleClient gradleClient;
    private final PidInstrumentation pidInstrumentation;
    private final BuildOperationInstrumentation buildOperationInstrumentation;
    private final Map<String, Duration> previousGcTimes = new HashMap<String, Duration>();
    BuildStepAction<GradleBuildInvocationResult> NO_OP = new BuildStepAction<GradleBuildInvocationResult>(){

        @Override
        public boolean isDoesSomething() {
            return false;
        }

        @Override
        public GradleBuildInvocationResult run(BuildContext buildContext, BuildStep buildStep) {
            return null;
        }
    };

    public BuildUnderTestInvoker(List<String> jvmArgs, List<String> gradleArgs, GradleClient gradleClient, PidInstrumentation pidInstrumentation, BuildOperationInstrumentation buildOperationInstrumentation) {
        this.jvmArgs = jvmArgs;
        this.gradleArgs = gradleArgs;
        this.gradleClient = gradleClient;
        this.pidInstrumentation = pidInstrumentation;
        this.buildOperationInstrumentation = buildOperationInstrumentation;
    }

    public BuildStepAction<GradleBuildInvocationResult> create(BuildAction action) {
        if (action.isDoesSomething()) {
            return new InvokeAndMeasureAction(action);
        }
        return this.NO_OP;
    }

    public BuildUnderTestInvoker withJvmArgs(List<String> jvmArgs) {
        if (jvmArgs.equals(this.jvmArgs)) {
            return this;
        }
        return this.copy(jvmArgs, this.gradleArgs);
    }

    public BuildUnderTestInvoker withGradleArgs(List<String> gradleArgs) {
        if (gradleArgs.equals(this.gradleArgs)) {
            return this;
        }
        return this.copy(this.jvmArgs, gradleArgs);
    }

    private BuildUnderTestInvoker copy(List<String> jvmArgs, List<String> gradleArgs) {
        return new BuildUnderTestInvoker(jvmArgs, gradleArgs, this.gradleClient, this.pidInstrumentation, this.buildOperationInstrumentation);
    }

    private class InvokeAndMeasureAction
    implements BuildStepAction<GradleBuildInvocationResult> {
        private final BuildAction action;

        public InvokeAndMeasureAction(BuildAction action) {
            this.action = action;
        }

        @Override
        public boolean isDoesSomething() {
            return true;
        }

        @Override
        public GradleBuildInvocationResult run(BuildContext buildContext, BuildStep buildStep) {
            ArrayList<String> jvmArgs = new ArrayList<String>(BuildUnderTestInvoker.this.jvmArgs);
            jvmArgs.add("-Dorg.gradle.profiler.phase=" + buildContext.getPhase());
            jvmArgs.add("-Dorg.gradle.profiler.phase.display.name=" + buildContext.getPhase().getDisplayName());
            jvmArgs.add("-Dorg.gradle.profiler.number=" + buildContext.getIteration());
            jvmArgs.add("-Dorg.gradle.profiler.step=" + buildStep);
            BuildActionResult buildActionResult = this.action.run(BuildUnderTestInvoker.this.gradleClient, BuildUnderTestInvoker.this.gradleArgs, jvmArgs);
            String pid = BuildUnderTestInvoker.this.pidInstrumentation.getPidForLastBuild();
            Logging.detailed().printf("Used daemon with pid %s%n", pid);
            Optional<Duration> garbageCollectionTime = BuildUnderTestInvoker.this.buildOperationInstrumentation.getTotalGarbageCollectionTime().map(currentTotal -> {
                Duration previousTotal = BuildUnderTestInvoker.this.previousGcTimes.getOrDefault(pid, Duration.ZERO);
                BuildUnderTestInvoker.this.previousGcTimes.put(pid, (Duration)currentTotal);
                return currentTotal.minus(previousTotal);
            });
            Optional<Long> localBuildCacheSize = BuildUnderTestInvoker.this.buildOperationInstrumentation.getLocalBuildCacheSize();
            Optional<Duration> timeToTaskExecution = BuildUnderTestInvoker.this.buildOperationInstrumentation.getTimeToTaskExecution();
            Map<String, BuildOperationExecutionData> totalExecutionData = BuildUnderTestInvoker.this.buildOperationInstrumentation.getTotalBuildOperationExecutionData();
            totalExecutionData.forEach((opName, duration) -> Logging.detailed().printf("Total build operation time %s ms (%s occurrences) for %s%n", duration.getValue(), duration.getTotalCount(), opName));
            garbageCollectionTime.ifPresent(duration -> Logging.detailed().printf("Total GC time: %d ms%n", duration.toMillis()));
            timeToTaskExecution.ifPresent(duration -> Logging.detailed().printf("Time to task execution %d ms%n", duration.toMillis()));
            return new GradleBuildInvocationResult(buildContext, buildActionResult, garbageCollectionTime.orElse(null), localBuildCacheSize.orElse(null), timeToTaskExecution.orElse(null), totalExecutionData, pid);
        }
    }
}

