/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.util.List;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractJavaSourceFileMutator;

public class ApplyNonAbiChangeToJavaSourceFileMutator
extends AbstractJavaSourceFileMutator {
    public ApplyNonAbiChangeToJavaSourceFileMutator(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void applyChangeTo(BuildContext context, CompilationUnit compilationUnit) {
        MethodDeclaration existingMethod = this.getExistingMethod(compilationUnit);
        ((BlockStmt)existingMethod.getBody().orElseThrow(() -> new RuntimeException("Method body not found"))).addStatement(0, (Statement)new JavaParser().parseStatement("System.out.println(\"" + context.getUniqueBuildId() + "\");").getResult().get());
    }

    private MethodDeclaration getExistingMethod(CompilationUnit compilationUnit) {
        NodeList types = compilationUnit.getTypes();
        if (types.isEmpty()) {
            throw new IllegalArgumentException("No types to change in " + this.sourceFile);
        }
        TypeDeclaration type = (TypeDeclaration)types.get(0);
        List methods = type.getMethods();
        if (methods.isEmpty()) {
            throw new IllegalArgumentException("No methods to change in " + this.sourceFile);
        }
        return (MethodDeclaration)methods.get(0);
    }
}

