/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import org.gradle.profiler.mutations.AbstractDelegateFileMutator;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;
import org.gradle.profiler.mutations.ApplyNonAbiChangeToJavaSourceFileMutator;
import org.gradle.profiler.mutations.ApplyNonAbiChangeToKotlinSourceFileMutator;

public class ApplyNonAbiChangeToSourceFileMutator
extends AbstractDelegateFileMutator {
    public ApplyNonAbiChangeToSourceFileMutator(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected AbstractFileChangeMutator getFileChangeMutator(File sourceFile) {
        if (sourceFile.getName().endsWith(".kt")) {
            return new ApplyNonAbiChangeToKotlinSourceFileMutator(sourceFile);
        }
        if (sourceFile.getName().endsWith(".java")) {
            return new ApplyNonAbiChangeToJavaSourceFileMutator(sourceFile);
        }
        throw new IllegalArgumentException("Can only modify Java or Kotlin source files");
    }
}

