/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;
import org.gradle.profiler.mutations.support.FileSupport;
import org.gradle.profiler.mutations.support.ScenarioSupport;

public class ApplyProjectDependencyChangeMutator
extends AbstractFileChangeMutator {
    private final ProjectCombinations projectCombinations;
    private final File projectDir;
    private final File settingsFile;
    private final File generatedProjectsDir;
    private final ProjectCombinations combinations;
    private final boolean shouldCreateProjects;
    private String originalSettingsText;

    public ApplyProjectDependencyChangeMutator(File projectDir, File sourceFile, ProjectCombinations projectCombinations, boolean shouldCreateProjects) {
        super(sourceFile);
        this.projectDir = projectDir;
        this.settingsFile = this.getSettingsFile();
        this.projectCombinations = projectCombinations;
        this.generatedProjectsDir = new File(projectDir, "gradle-profiler-generated-projects");
        this.combinations = projectCombinations;
        this.shouldCreateProjects = shouldCreateProjects;
    }

    private File getSettingsFile() {
        return Stream.of("settings.gradle", "settings.gradle.kts").map(it -> new File(this.projectDir, (String)it)).filter(File::exists).findFirst().orElseThrow(() -> new IllegalStateException("No settings.gradle(.kts) file found in " + this.projectDir));
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        super.beforeScenario(context);
        if (this.shouldCreateProjects) {
            this.originalSettingsText = FileSupport.readUnchecked(this.settingsFile.toPath());
            FileUtils.deleteQuietly((File)this.generatedProjectsDir);
            this.createProjects(this.combinations.getProjectNames());
            String includeProjects = this.combinations.getProjectNames().stream().map(it -> {
                String include = String.format("\ninclude(\"%s\")", it);
                String projectDir = String.format("\nproject(\":%s\").projectDir = file(\"%s/%s\")", it, this.generatedProjectsDir.getName(), it);
                return include + projectDir;
            }).collect(Collectors.joining());
            FileSupport.writeUnchecked(this.settingsFile.toPath(), includeProjects, StandardOpenOption.APPEND);
        }
    }

    private void createProjects(List<String> projectNames) {
        for (String projectName : projectNames) {
            File projectDir = new File(this.generatedProjectsDir, projectName);
            projectDir.mkdirs();
            File buildGradle = new File(projectDir, "build.gradle");
            FileSupport.writeUnchecked(buildGradle.toPath(), "plugins { id 'java' }", new OpenOption[0]);
        }
    }

    @Override
    public void afterScenario(ScenarioContext context) {
        super.afterScenario(context);
        if (this.shouldCreateProjects) {
            this.revert(this.settingsFile, this.originalSettingsText);
            try {
                FileUtils.forceDelete((File)this.generatedProjectsDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void validate(BuildInvoker invoker) {
    }

    @Override
    protected void applyChangeTo(BuildContext context, StringBuilder text) {
        text.append("\ndependencies {\n");
        Set<String> projects = this.projectCombinations.getNextCombination();
        projects.forEach(it -> text.append("    project(\":").append((String)it).append("\")\n"));
        text.append("}");
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        public static final String DEPENDENCY_COUNT_KEY = "dependency-count";
        private static final String FILES_KEY = "files";
        private static final Set<String> VALID_CONFIG_KEYS = ImmutableSet.of((Object)"dependency-count", (Object)"files");
        private static final int DEFAULT_APPLIED_PROJECTS_COUNT = 3;

        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            Config config = spec.getScenario().getConfig(key);
            this.validateConfig(key, spec.getScenarioName(), spec.getScenarioFile(), config);
            int appliedProjectCount = this.getAppliedProjectCount(config);
            List<File> sourceFiles = ScenarioSupport.sourceFiles(config, spec.getScenarioName(), spec.getProjectDir(), FILES_KEY);
            ProjectCombinations combinations = this.getProjectCombinations(spec, sourceFiles.size(), appliedProjectCount);
            AtomicInteger index = new AtomicInteger();
            List<BuildMutator> mutatorsForKey = sourceFiles.stream().map(sourceFileToChange -> {
                boolean shouldCreateProjects = index.getAndIncrement() == 0;
                return new ApplyProjectDependencyChangeMutator(spec.getProjectDir(), (File)sourceFileToChange, combinations, shouldCreateProjects);
            }).collect(Collectors.toList());
            return CompositeBuildMutator.from(mutatorsForKey);
        }

        private ProjectCombinations getProjectCombinations(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, int numberOfProjects, int appliedProjectDependencies) {
            int numberOfIterations = spec.getWarmupCount() + spec.getBuildCount();
            int numberOfRequiredCombinations = numberOfIterations * numberOfProjects;
            return ProjectCombinations.createProjectCombinations(numberOfRequiredCombinations, appliedProjectDependencies);
        }

        private void validateConfig(String key, String scenarioName, File scenarioFile, Config config) {
            Set invalidKeys = config.entrySet().stream().map(Map.Entry::getKey).filter(entryKey -> !VALID_CONFIG_KEYS.contains(entryKey)).collect(Collectors.toSet());
            if (!invalidKeys.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized keys " + invalidKeys + " found for '" + scenarioName + "." + key + "' defined in scenario file " + scenarioFile + ": " + invalidKeys);
            }
        }

        private int getAppliedProjectCount(Config config) {
            return config.hasPath(DEPENDENCY_COUNT_KEY) ? config.getInt(DEPENDENCY_COUNT_KEY) : 3;
        }
    }

    public static class ProjectCombinations {
        private final List<String> projectNames;
        private final Iterator<Set<String>> combinations;

        public ProjectCombinations(List<String> projectNames, Set<Set<String>> combinations) {
            this.projectNames = Collections.unmodifiableList(projectNames);
            this.combinations = combinations.iterator();
        }

        public List<String> getProjectNames() {
            return this.projectNames;
        }

        public Set<String> getNextCombination() {
            return this.combinations.next();
        }

        @VisibleForTesting
        static ProjectCombinations createProjectCombinations(int numberOfRequiredCombinations, int appliedProjectsCount) {
            Preconditions.checkArgument((appliedProjectsCount > 0 ? 1 : 0) != 0, (Object)String.format("Value '%s' should be greater than 0.", "dependency-count"));
            int projectsToGenerate = ProjectCombinations.calculateNumberOfProjectsToGenerate(numberOfRequiredCombinations, appliedProjectsCount);
            List<String> projectNames = IntStream.range(0, projectsToGenerate).mapToObj(index -> String.format("generated-dependency-%s", index)).collect(Collectors.toList());
            Set combinations = Sets.combinations(new LinkedHashSet(projectNames), (int)appliedProjectsCount);
            return new ProjectCombinations(projectNames, combinations);
        }

        private static int calculateNumberOfProjectsToGenerate(int numberOfRequiredCombinations, int appliedProjectsCount) {
            if (appliedProjectsCount == 1) {
                return numberOfRequiredCombinations;
            }
            int projectsToGenerate = appliedProjectsCount;
            while (IntMath.binomial((int)projectsToGenerate, (int)appliedProjectsCount) < numberOfRequiredCombinations) {
                ++projectsToGenerate;
            }
            return projectsToGenerate;
        }
    }
}

