/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.profiler.GradleArgsCalculator;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ProfilerController;
import org.gradle.profiler.ScenarioSettings;

public abstract class Profiler {
    public static final Profiler NONE = new Profiler(){

        @Override
        public boolean requiresGradle() {
            return false;
        }

        public String toString() {
            return "none";
        }
    };

    public abstract boolean requiresGradle();

    public void validate(ScenarioSettings settings, Consumer<String> reporter) {
    }

    public ProfilerController newController(String pid, ScenarioSettings settings) {
        return ProfilerController.EMPTY;
    }

    public JvmArgsCalculator newJvmArgsCalculator(ScenarioSettings settings) {
        return JvmArgsCalculator.DEFAULT;
    }

    public JvmArgsCalculator newInstrumentedBuildsJvmArgsCalculator(ScenarioSettings settings) {
        return JvmArgsCalculator.DEFAULT;
    }

    public GradleArgsCalculator newGradleArgsCalculator(ScenarioSettings settings) {
        return GradleArgsCalculator.DEFAULT;
    }

    public GradleArgsCalculator newInstrumentedBuildsGradleArgsCalculator(ScenarioSettings settings) {
        return GradleArgsCalculator.DEFAULT;
    }

    public void summarizeResultFile(File resultFile, Consumer<String> consumer) {
    }

    public boolean isCreatesStacksFiles() {
        return false;
    }
}

