/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public abstract class AbstractScheduledMutator
implements BuildMutator {
    private final Schedule schedule;

    public AbstractScheduledMutator(Schedule schedule) {
        this.schedule = schedule;
    }

    @Override
    public void validate(BuildInvoker invoker) {
        if (this.schedule != Schedule.SCENARIO && !invoker.allowsMutationBetweenBuilds()) {
            throw new IllegalStateException(this + " is not allowed to be executed between builds with invoker " + invoker);
        }
    }

    @Override
    public void beforeBuild(BuildContext context) {
        if (this.schedule == Schedule.BUILD) {
            this.executeOnSchedule();
        }
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        if (this.schedule == Schedule.SCENARIO) {
            this.executeOnSchedule();
        }
    }

    @Override
    public void beforeCleanup(BuildContext context) {
        if (this.schedule == Schedule.CLEANUP) {
            this.executeOnSchedule();
        }
    }

    protected abstract void executeOnSchedule();

    protected static void delete(File f) {
        try {
            if (f.isFile()) {
                Files.delete(f.toPath());
            } else {
                FileUtils.deleteDirectory((File)f);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not delete " + f, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.schedule) + ")";
    }

    public static enum Schedule {
        SCENARIO,
        CLEANUP,
        BUILD;

    }

    protected static abstract class Configurator
    implements BuildMutatorConfigurator {
        protected Configurator() {
        }

        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            Schedule schedule = ConfigUtil.enumValue(spec.getScenario(), key, Schedule.class, null);
            if (schedule == null) {
                throw new IllegalArgumentException("Schedule is not specified");
            }
            return this.newInstance(spec, key, schedule);
        }

        protected abstract BuildMutator newInstance(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec var1, String var2, Schedule var3);
    }
}

