/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class ClearProjectCacheMutator
extends AbstractScheduledMutator {
    private final File projectDir;

    public ClearProjectCacheMutator(File projectDir, AbstractScheduledMutator.Schedule schedule) {
        super(schedule);
        this.projectDir = projectDir;
    }

    @Override
    protected void executeOnSchedule() {
        this.deleteGradleCache("project", this.projectDir);
        File buildSrc = new File(this.projectDir, "buildSrc");
        if (buildSrc.exists()) {
            this.deleteGradleCache("buildSrc", buildSrc);
        }
    }

    private void deleteGradleCache(String name, File baseDir) {
        File gradleCache = new File(baseDir, ".gradle");
        System.out.println(String.format("> Cleaning %s .gradle cache: %s", name, gradleCache));
        try {
            FileUtils.deleteDirectory((File)gradleCache);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractScheduledMutator.Configurator {
        @Override
        protected BuildMutator newInstance(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, String key, AbstractScheduledMutator.Schedule schedule) {
            return new ClearProjectCacheMutator(spec.getProjectDir(), schedule);
        }
    }
}

