/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.profiler.GradleArgsCalculator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerController;
import org.gradle.profiler.ScenarioSettings;

class CompositeProfiler
extends Profiler {
    private final List<Profiler> delegates;

    CompositeProfiler(List<Profiler> delegates) {
        this.delegates = delegates;
    }

    @Override
    public boolean requiresGradle() {
        return this.delegates.stream().anyMatch(Profiler::requiresGradle);
    }

    public String toString() {
        return this.delegates.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public void validate(ScenarioSettings settings, Consumer<String> reporter) {
        for (Profiler delegate : this.delegates) {
            delegate.validate(settings, reporter);
        }
    }

    @Override
    public void summarizeResultFile(File resultFile, Consumer<String> consumer) {
        for (Profiler delegate : this.delegates) {
            delegate.summarizeResultFile(resultFile, consumer);
        }
    }

    @Override
    public ProfilerController newController(String pid, ScenarioSettings settings) {
        final List controllers = this.delegates.stream().map(prof -> prof.newController(pid, this.settingsFor((Profiler)prof, settings))).collect(Collectors.toList());
        return new ProfilerController(){

            @Override
            public void startSession() throws IOException, InterruptedException {
                for (ProfilerController controller : controllers) {
                    controller.startSession();
                }
            }

            @Override
            public void startRecording() throws IOException, InterruptedException {
                for (ProfilerController controller : controllers) {
                    controller.startRecording();
                }
            }

            @Override
            public void stopRecording(String pid) throws IOException, InterruptedException {
                for (ProfilerController controller : controllers) {
                    controller.stopRecording(pid);
                }
            }

            @Override
            public void stopSession() throws IOException, InterruptedException {
                for (ProfilerController controller : controllers) {
                    controller.stopSession();
                }
            }
        };
    }

    private ScenarioSettings settingsFor(Profiler prof, ScenarioSettings scenarioSettings) {
        InvocationSettings settings = scenarioSettings.getInvocationSettings();
        InvocationSettings newSettings = settings.newBuilder().setProfiler(prof).build();
        return new ScenarioSettings(newSettings, scenarioSettings.getScenario());
    }

    @Override
    public JvmArgsCalculator newJvmArgsCalculator(ScenarioSettings settings) {
        return jvmArgs -> this.delegates.forEach(prof -> prof.newJvmArgsCalculator(this.settingsFor((Profiler)prof, settings)).calculateJvmArgs(jvmArgs));
    }

    @Override
    public JvmArgsCalculator newInstrumentedBuildsJvmArgsCalculator(ScenarioSettings settings) {
        return jvmArgs -> this.delegates.forEach(prof -> prof.newInstrumentedBuildsJvmArgsCalculator(this.settingsFor((Profiler)prof, settings)).calculateJvmArgs(jvmArgs));
    }

    @Override
    public GradleArgsCalculator newGradleArgsCalculator(final ScenarioSettings settings) {
        return new GradleArgsCalculator(){

            @Override
            public void calculateGradleArgs(List<String> gradleArgs) {
                CompositeProfiler.this.delegates.forEach(prof -> prof.newGradleArgsCalculator(CompositeProfiler.this.settingsFor(prof, settings)).calculateGradleArgs(gradleArgs));
            }
        };
    }

    @Override
    public GradleArgsCalculator newInstrumentedBuildsGradleArgsCalculator(final ScenarioSettings settings) {
        return new GradleArgsCalculator(){

            @Override
            public void calculateGradleArgs(List<String> gradleArgs) {
                CompositeProfiler.this.delegates.forEach(prof -> prof.newInstrumentedBuildsGradleArgsCalculator(CompositeProfiler.this.settingsFor(prof, settings)).calculateGradleArgs(gradleArgs));
            }
        };
    }

    @Override
    public boolean isCreatesStacksFiles() {
        return this.delegates.stream().anyMatch(Profiler::isCreatesStacksFiles);
    }
}

