/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class ClearGradleUserHomeMutator
extends AbstractScheduledMutator {
    private final File gradleUserHome;

    public ClearGradleUserHomeMutator(File gradleUserHome, AbstractScheduledMutator.Schedule schedule) {
        super(schedule);
        this.gradleUserHome = gradleUserHome;
    }

    @Override
    protected void executeOnSchedule() {
        System.out.println(String.format("> Cleaning Gradle user home: %s", this.gradleUserHome.getAbsolutePath()));
        if (!this.gradleUserHome.exists()) {
            throw new IllegalArgumentException(String.format("Cannot delete Gradle user home directory (%s) since it does not exist", this.gradleUserHome));
        }
        try {
            Files.list(this.gradleUserHome.toPath()).filter(path -> !path.getFileName().toString().equals("wrapper")).forEach(path -> ClearGradleUserHomeMutator.delete(path.toFile()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractScheduledMutator.Configurator {
        @Override
        protected BuildMutator newInstance(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, String key, AbstractScheduledMutator.Schedule schedule) {
            return new ClearGradleUserHomeMutator(spec.getGradleUserHome(), schedule);
        }
    }
}

