/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.ServerConnection;

public class Server
implements Closeable {
    private final ServerSocketChannel serverSocketChannel;
    private final Selector selector;
    private final List<ServerConnection> connections = new ArrayList<ServerConnection>();
    private final String peerName;

    public Server(String peerName) {
        this.peerName = peerName;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.bind(new InetSocketAddress((InetAddress)null, 0));
            this.serverSocketChannel.configureBlocking(false);
            this.selector = Selector.open();
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not start listening for incoming %s connections.", peerName), e);
        }
    }

    public int getPort() {
        try {
            return ((InetSocketAddress)this.serverSocketChannel.getLocalAddress()).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not determine local port.", e);
        }
    }

    public ServerConnection waitForIncoming(Duration timeout) {
        try {
            int keys = this.selector.select(timeout.toMillis());
            if (keys != 1) {
                throw new IllegalStateException(String.format("Timeout waiting for incoming connection from %s.", this.peerName));
            }
            SocketChannel channel = this.serverSocketChannel.accept();
            ServerConnection connection = new ServerConnection(this.peerName, new Connection(channel.socket()));
            this.connections.add(connection);
            return connection;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not receive incoming connection from %s.", this.peerName), e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            for (ServerConnection connection : this.connections) {
                connection.close();
            }
            this.serverSocketChannel.close();
            this.selector.close();
        }
        finally {
            this.connections.clear();
        }
    }
}

