/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Optional;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.messages.Message;
import org.gradle.profiler.client.protocol.serialization.MessageSerializer;

public class MessageProtocolHandler {
    private static final int BODY_READ_TIMEOUT_MS = 0;
    private final String peerName;
    private final Connection connection;

    public MessageProtocolHandler(String peerName, Connection connection) {
        this.peerName = peerName;
        this.connection = connection;
    }

    public void send(Message message) {
        try {
            MessageSerializer serializer = MessageSerializer.getMessageSerializer(message.getClass());
            serializer.writeTo(this.connection, message);
            this.connection.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not write to %s.", this.peerName), e);
        }
    }

    public <T extends Message> Optional<T> maybeReceive(Class<T> type, Duration timeout) {
        return this.receive(timeout);
    }

    public <T extends Message> T receive(Class<T> type, Duration timeout) {
        return (T)((Message)this.receive(timeout).orElseThrow(() -> new IllegalStateException(String.format("Timeout waiting to receive %s.", type))));
    }

    private <T extends Message> Optional<T> receive(Duration timeout) {
        try {
            byte tag = this.connection.readByte((int)timeout.toMillis());
            MessageSerializer serializer = MessageSerializer.getMessageSerializer(tag);
            return Optional.of(serializer.readFrom(this.connection, 0));
        }
        catch (EOFException e) {
            throw new IllegalStateException(String.format("Connection to %s has closed.", this.peerName));
        }
        catch (SocketTimeoutException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not read from %s.", this.peerName), e);
        }
    }
}

