/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.List;

public class AsyncProfilerConfig {
    public static final String EVENT_ALLOC = "alloc";
    public static final String EVENT_LOCK = "lock";
    private final File profilerHome;
    private final List<String> events;
    private final Counter counter;
    private final int interval;
    private final int allocSampleSize;
    private final int lockThreshold;
    private final int stackDepth;
    private final boolean includeSystemThreads;

    public AsyncProfilerConfig(File profilerHome, List<String> events, Counter counter, int interval, int allocSampleSize, int lockThreshold, int stackDepth, boolean includeSystemThreads) {
        this.profilerHome = profilerHome;
        this.events = events;
        this.counter = counter;
        this.interval = interval;
        this.allocSampleSize = allocSampleSize;
        this.lockThreshold = lockThreshold;
        this.stackDepth = stackDepth;
        this.includeSystemThreads = includeSystemThreads;
    }

    public File getProfilerHome() {
        return this.profilerHome;
    }

    public String getJoinedEvents() {
        return Joiner.on((String)",").join(this.events);
    }

    public List<String> getEvents() {
        return this.events;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getAllocSampleSize() {
        return this.allocSampleSize;
    }

    public int getLockThreshold() {
        return this.lockThreshold;
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public boolean isIncludeSystemThreads() {
        return this.includeSystemThreads;
    }

    public static enum Counter {
        SAMPLES,
        TOTAL;

    }
}

