/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.gradle;

import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.Logging;
import org.gradle.profiler.gradle.GradleInvoker;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;

public class ToolingApiGradleClient
implements GradleInvoker,
GradleClient {
    private final ProjectConnection projectConnection;

    public ToolingApiGradleClient(ProjectConnection projectConnection) {
        this.projectConnection = projectConnection;
    }

    @Override
    public void close() {
        this.projectConnection.close();
    }

    private static <T extends LongRunningOperation, R> R run(T operation, Function<T, R> function) {
        operation.setStandardOutput((OutputStream)Logging.detailed());
        operation.setStandardError((OutputStream)Logging.detailed());
        try {
            return function.apply(operation);
        }
        catch (GradleConnectionException e) {
            System.out.println();
            System.out.println("ERROR: failed to run build. See log file for details.");
            System.out.println();
            throw e;
        }
    }

    public <T extends LongRunningOperation, R> R runOperation(Function<ProjectConnection, T> createOperation, Function<T, R> operationAction) {
        return ToolingApiGradleClient.run((LongRunningOperation)createOperation.apply(this.projectConnection), operationAction);
    }

    @Override
    public void runTasks(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs) {
        this.runOperation(ProjectConnection::newBuild, build -> {
            build.forTasks(tasks.toArray(new String[0]));
            build.withArguments((Iterable)gradleArgs);
            build.setJvmArguments((Iterable)jvmArgs);
            build.run();
            return null;
        });
    }

    @Override
    public void loadToolingModel(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs, Class<?> toolingModel) {
        this.runOperation(connection -> connection.model(toolingModel), build -> {
            build.forTasks(tasks.toArray(new String[0]));
            build.withArguments((Iterable)gradleArgs);
            build.setJvmArguments((Iterable)jvmArgs);
            build.get();
            return null;
        });
    }

    @Override
    public <T> T runToolingAction(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs, BuildAction<T> action, Consumer<BuildActionExecuter<?>> configureAction) {
        return (T)this.runOperation(connection -> connection.action(action), build -> {
            if (!tasks.isEmpty()) {
                build.forTasks(tasks.toArray(new String[0]));
            }
            build.withArguments((Iterable)gradleArgs);
            build.setJvmArguments((Iterable)jvmArgs);
            configureAction.accept((BuildActionExecuter<?>)build);
            return build.run();
        });
    }
}

