/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;

public class ApplyChangeToAndroidLayoutFileMutator
extends AbstractFileChangeMutator {
    public ApplyChangeToAndroidLayoutFileMutator(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void applyChangeTo(BuildContext context, StringBuilder text) {
        int insertPos = text.lastIndexOf("</layout>");
        if (insertPos < 0) {
            this.applyChangeToNonDataBindingLayout(context, text);
        } else {
            this.applyChangeToDataBindingLayout(context, text, insertPos);
        }
    }

    private void applyChangeToDataBindingLayout(BuildContext context, StringBuilder text, int tagEndPosition) {
        String substring = text.substring(0, tagEndPosition);
        int insertPos = substring.lastIndexOf("</");
        if (insertPos < 0) {
            throw new IllegalArgumentException("Cannot parse android layout file " + this.sourceFile + " to apply changes position " + insertPos);
        }
        text.insert(insertPos, this.generateUniqueViewItem(context));
    }

    private void applyChangeToNonDataBindingLayout(BuildContext context, StringBuilder text) {
        int insertPos = text.lastIndexOf("</");
        if (insertPos < 0) {
            throw new IllegalArgumentException("Cannot parse android layout file " + this.sourceFile + " to apply changes");
        }
        text.insert(insertPos, this.generateUniqueViewItem(context));
    }

    private String generateUniqueViewItem(BuildContext context) {
        return "<View \n    android:id=\"@+id/view" + context.getUniqueBuildId() + "\"\n    android:visibility=\"gone\"\n    android:layout_width=\"5dp\"\n    android:layout_height=\"5dp\"/>\n\n";
    }
}

