/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.mutations.AbstractFileSystemMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class DeleteFileMutator
extends AbstractFileSystemMutator {
    private final File target;

    public DeleteFileMutator(File target, AbstractScheduledMutator.Schedule schedule) {
        super(schedule);
        this.target = target;
    }

    @Override
    protected void executeOnSchedule() {
        System.out.println("Removing file: '" + this.target.getAbsolutePath() + "'");
        try {
            if (this.target.exists()) {
                FileUtils.forceDelete((File)this.target);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete '" + this.target.getAbsolutePath() + "'", e);
        }
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            return CompositeBuildMutator.from(ConfigUtil.configs(spec.getScenario(), key).stream().map(config -> Configurator.createMutator(spec, config)).collect(Collectors.toList()));
        }

        private static DeleteFileMutator createMutator(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, Config config) {
            String target = ConfigUtil.string(config, "target");
            AbstractScheduledMutator.Schedule schedule = ConfigUtil.enumValue(config, "schedule", AbstractScheduledMutator.Schedule.class, AbstractScheduledMutator.Schedule.SCENARIO);
            File projectDir = spec.getProjectDir();
            return new DeleteFileMutator(AbstractFileSystemMutator.resolveProjectFile(projectDir, target), schedule);
        }
    }
}

