/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.BuildToolCommandLineScenarioDefinition;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Logging;
import org.gradle.profiler.Phase;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioInvoker;
import org.gradle.profiler.Timer;
import org.gradle.profiler.result.BuildActionResult;
import org.gradle.profiler.result.BuildInvocationResult;

public abstract class BuildToolCommandLineInvoker<T extends BuildToolCommandLineScenarioDefinition, R extends BuildInvocationResult>
extends ScenarioInvoker<T, R> {
    protected void doRun(T scenario, InvocationSettings settings, Consumer<BuildInvocationResult> resultConsumer, List<String> commandLine, Map<String, String> envVars) {
        this.doRun(scenario, settings, resultConsumer, commandLine, envVars, (List<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(T scenario, InvocationSettings settings, Consumer<BuildInvocationResult> resultConsumer, List<String> commandLine, Map<String, String> envVars, List<String> profileCommandLine, Map<String, String> profileEnvVars) {
        ScenarioContext scenarioContext = ScenarioContext.from(settings, scenario);
        BuildMutator mutator = CompositeBuildMutator.from(((ScenarioDefinition)scenario).getBuildMutators());
        mutator.beforeScenario(scenarioContext);
        try {
            BuildContext buildContext;
            int iteration;
            for (iteration = 1; iteration <= ((ScenarioDefinition)scenario).getWarmUpCount(); ++iteration) {
                buildContext = scenarioContext.withBuild(Phase.WARM_UP, iteration);
                BuildStepAction<R> action = this.measureCommandLineExecution(commandLine, envVars, settings.getProjectDir(), settings.getBuildLog());
                this.runMeasured(buildContext, mutator, action, resultConsumer);
            }
            for (iteration = 1; iteration <= ((ScenarioDefinition)scenario).getBuildCount(); ++iteration) {
                buildContext = scenarioContext.withBuild(Phase.MEASURE, iteration);
                ImmutableList commandLineCombined = ImmutableList.builder().addAll(commandLine).addAll(profileCommandLine).build();
                ImmutableMap envVarsCombined = ImmutableMap.builder().putAll(envVars).putAll(profileEnvVars).build();
                BuildStepAction<R> action = this.measureCommandLineExecution((List<String>)commandLineCombined, (Map<String, String>)envVarsCombined, settings.getProjectDir(), settings.getBuildLog());
                this.runMeasured(buildContext, mutator, action, resultConsumer);
            }
        }
        finally {
            mutator.afterScenario(scenarioContext);
        }
    }

    private BuildStepAction<R> measureCommandLineExecution(final List<String> commandLine, final Map<String, String> envVars, final File workingDir, final File buildLog) {
        return new BuildStepAction<R>(){

            @Override
            public boolean isDoesSomething() {
                return true;
            }

            @Override
            public R run(BuildContext buildContext, BuildStep buildStep) {
                Logging.detailed().println("  Command: " + commandLine);
                Logging.detailed().println("  Environment: " + envVars);
                CommandExec commandExec = new CommandExec().inDir(workingDir).environmentVariables(envVars);
                Timer timer = new Timer();
                if (buildLog == null) {
                    commandExec.run(commandLine);
                } else {
                    commandExec.runAndCollectOutput(buildLog, commandLine);
                }
                Duration executionTime = timer.elapsed();
                return new BuildInvocationResult(buildContext, new BuildActionResult(executionTime));
            }
        };
    }
}

