/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.IOException;
import java.util.function.Consumer;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerController;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioSettings;

public abstract class InstrumentingProfiler
extends Profiler {
    @Override
    public boolean requiresGradle() {
        return false;
    }

    @Override
    public JvmArgsCalculator newJvmArgsCalculator(ScenarioSettings settings) {
        if (!settings.getScenario().getInvoker().isReuseDaemon()) {
            return JvmArgsCalculator.DEFAULT;
        }
        return this.jvmArgsWithInstrumentation(settings, false, false);
    }

    @Override
    public JvmArgsCalculator newInstrumentedBuildsJvmArgsCalculator(ScenarioSettings settings) {
        if (settings.getScenario().getInvoker().isReuseDaemon()) {
            return JvmArgsCalculator.DEFAULT;
        }
        boolean captureSnapshotOnExit = settings.getScenario().getInvoker().isDoesNotUseDaemon();
        return this.jvmArgsWithInstrumentation(settings, true, captureSnapshotOnExit);
    }

    @Override
    public ProfilerController newController(String pid, ScenarioSettings settings) {
        SnapshotCapturingProfilerController controller = this.newSnapshottingController(settings);
        if (settings.getScenario().getInvoker().isDoesNotUseDaemon()) {
            return new SessionOnlyController(pid, controller);
        }
        if (settings.getScenario().getInvoker().isReuseDaemon()) {
            return new CaptureSnapshotOnSessionEndController(pid, controller);
        }
        return new RecordingAlreadyStartedController(pid, controller);
    }

    @Override
    public void validate(ScenarioSettings settings, Consumer<String> reporter) {
        this.validateMultipleIterationsWithCleanupAction(settings, reporter);
        this.validateMultipleDaemons(settings, reporter);
    }

    protected void validateMultipleIterationsWithCleanupAction(ScenarioSettings settings, Consumer<String> reporter) {
        ScenarioDefinition scenario = settings.getScenario();
        if (scenario.getBuildCount() > 1 && !this.canRestartRecording(settings) && scenario.doesCleanup()) {
            reporter.accept("Profiler " + this.toString() + " does not support profiling multiple iterations with cleanup steps in between.");
        }
    }

    protected void validateMultipleDaemons(ScenarioSettings settings, Consumer<String> reporter) {
        ScenarioDefinition scenario = settings.getScenario();
        if (scenario.getBuildCount() > 1 && !scenario.getInvoker().isReuseDaemon()) {
            reporter.accept("Profiler " + this.toString() + " does not support profiling multiple daemons.");
        }
    }

    protected boolean canRestartRecording(ScenarioSettings settings) {
        return false;
    }

    protected abstract JvmArgsCalculator jvmArgsWithInstrumentation(ScenarioSettings var1, boolean var2, boolean var3);

    public abstract SnapshotCapturingProfilerController newSnapshottingController(ScenarioSettings var1);

    private static class SessionOnlyController
    extends DelegatingController {
        SessionOnlyController(String pid, SnapshotCapturingProfilerController controller) {
            super(pid, controller);
        }

        @Override
        public void startRecording() throws IOException, InterruptedException {
        }

        @Override
        public void stopRecording(String pid) throws IOException, InterruptedException {
        }
    }

    private static class RecordingAlreadyStartedController
    extends DelegatingController {
        RecordingAlreadyStartedController(String pid, SnapshotCapturingProfilerController controller) {
            super(pid, controller);
        }

        @Override
        public void startRecording() throws IOException, InterruptedException {
        }

        @Override
        public void stopRecording(String pid) throws IOException, InterruptedException {
            this.controller.stopRecording(pid);
            this.controller.captureSnapshot(pid);
        }
    }

    private static class CaptureSnapshotOnSessionEndController
    extends DelegatingController {
        private String mostRecentPid;

        public CaptureSnapshotOnSessionEndController(String pid, SnapshotCapturingProfilerController controller) {
            super(pid, controller);
        }

        @Override
        public void stopRecording(String pid) throws IOException, InterruptedException {
            super.stopRecording(pid);
            this.mostRecentPid = pid;
        }

        @Override
        public void stopSession() throws IOException, InterruptedException {
            this.controller.captureSnapshot(this.mostRecentPid);
            this.controller.stopSession();
        }
    }

    private static class DelegatingController
    implements ProfilerController {
        protected final String pid;
        protected final SnapshotCapturingProfilerController controller;

        DelegatingController(String pid, SnapshotCapturingProfilerController controller) {
            this.pid = pid;
            this.controller = controller;
        }

        @Override
        public void startSession() throws IOException, InterruptedException {
        }

        @Override
        public void startRecording() throws IOException, InterruptedException {
            this.controller.startRecording(this.pid);
        }

        @Override
        public void stopRecording(String pid) throws IOException, InterruptedException {
            this.controller.stopRecording(pid);
        }

        @Override
        public void stopSession() throws IOException, InterruptedException {
            this.controller.stopSession();
        }
    }

    public static interface SnapshotCapturingProfilerController {
        public void startRecording(String var1) throws IOException, InterruptedException;

        public void stopRecording(String var1) throws IOException, InterruptedException;

        public void captureSnapshot(String var1) throws IOException, InterruptedException;

        public void stopSession() throws IOException, InterruptedException;
    }
}

