/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.profiler.BenchmarkResultCollector;
import org.gradle.profiler.CommandLineParser;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Logging;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioInvoker;
import org.gradle.profiler.ScenarioLoader;
import org.gradle.profiler.bazel.BazelScenarioDefinition;
import org.gradle.profiler.bazel.BazelScenarioInvoker;
import org.gradle.profiler.buck.BuckScenarioDefinition;
import org.gradle.profiler.buck.BuckScenarioInvoker;
import org.gradle.profiler.flamegraph.DifferentialStacksGenerator;
import org.gradle.profiler.flamegraph.FlameGraphGenerator;
import org.gradle.profiler.flamegraph.Stacks;
import org.gradle.profiler.gradle.DaemonControl;
import org.gradle.profiler.gradle.DefaultGradleBuildConfigurationReader;
import org.gradle.profiler.gradle.GradleScenarioDefinition;
import org.gradle.profiler.gradle.GradleScenarioInvoker;
import org.gradle.profiler.instrument.PidInstrumentation;
import org.gradle.profiler.maven.MavenScenarioDefinition;
import org.gradle.profiler.maven.MavenScenarioInvoker;
import org.gradle.profiler.report.CsvGenerator;
import org.gradle.profiler.report.HtmlGenerator;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.SampleProvider;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioInvoker;

public class Main {
    public static void main(String[] args) {
        boolean ok;
        try {
            new Main().run(args);
            ok = true;
        }
        catch (Exception e) {
            ok = false;
        }
        System.exit(ok ? 0 : 1);
    }

    public void run(String[] args) throws Exception {
        try {
            Instant started = Instant.now();
            InvocationSettings settings = new CommandLineParser().parseSettings(args);
            if (settings == null) {
                return;
            }
            if (settings.isDumpScenarios()) {
                Main.printScenariosConfigDump(settings);
                return;
            }
            System.out.println();
            System.out.println("* Writing results to " + settings.getOutputDir().getAbsolutePath());
            Logging.setupLogging(settings.getOutputDir());
            Logging.detailed().println();
            Logging.detailed().println("* Started at " + started);
            Logging.startOperation("Settings");
            settings.printTo(System.out);
            DaemonControl daemonControl = new DaemonControl(settings.getGradleUserHome());
            DefaultGradleBuildConfigurationReader gradleBuildConfigurationReader = new DefaultGradleBuildConfigurationReader(settings.getProjectDir(), settings.getGradleUserHome(), daemonControl);
            ScenarioLoader scenarioLoader = new ScenarioLoader(gradleBuildConfigurationReader);
            List<ScenarioDefinition> scenarios = scenarioLoader.loadScenarios(settings);
            int totalScenarios = scenarios.size();
            this.logScenarios(scenarios);
            File cvsFile = new File(settings.getOutputDir(), "benchmark.csv");
            File htmlFile = new File(settings.getOutputDir(), "benchmark.html");
            BenchmarkResultCollector benchmarkResults = new BenchmarkResultCollector(new CsvGenerator(cvsFile, settings.getCsvFormat()), new HtmlGenerator(htmlFile));
            PidInstrumentation pidInstrumentation = new PidInstrumentation();
            GradleScenarioInvoker gradleScenarioInvoker = new GradleScenarioInvoker(daemonControl, pidInstrumentation);
            StudioGradleScenarioInvoker studioGradleScenarioInvoker = new StudioGradleScenarioInvoker(gradleScenarioInvoker);
            BazelScenarioInvoker bazelScenarioInvoker = new BazelScenarioInvoker();
            BuckScenarioInvoker buckScenarioInvoker = new BuckScenarioInvoker();
            MavenScenarioInvoker mavenScenarioInvoker = new MavenScenarioInvoker();
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            int scenarioCount = 0;
            for (ScenarioDefinition scenario : scenarios) {
                Logging.startOperation("Running scenario " + scenario.getDisplayName() + " (scenario " + ++scenarioCount + "/" + totalScenarios + ")");
                if (settings.isProfile() && scenario.getWarmUpCount() == 0) {
                    throw new IllegalStateException("Using the --profile option requires at least one warm-up");
                }
                if (scenario instanceof BazelScenarioDefinition) {
                    this.invoke(bazelScenarioInvoker, (BazelScenarioDefinition)scenario, settings, benchmarkResults, failures);
                    continue;
                }
                if (scenario instanceof BuckScenarioDefinition) {
                    this.invoke(buckScenarioInvoker, (BuckScenarioDefinition)scenario, settings, benchmarkResults, failures);
                    continue;
                }
                if (scenario instanceof MavenScenarioDefinition) {
                    this.invoke(mavenScenarioInvoker, (MavenScenarioDefinition)scenario, settings, benchmarkResults, failures);
                    continue;
                }
                if (scenario instanceof StudioGradleScenarioDefinition) {
                    this.invoke(studioGradleScenarioInvoker, (StudioGradleScenarioDefinition)scenario, settings, benchmarkResults, failures);
                    continue;
                }
                if (scenario instanceof GradleScenarioDefinition) {
                    this.invoke(gradleScenarioInvoker, (GradleScenarioDefinition)scenario, settings, benchmarkResults, failures);
                    continue;
                }
                throw new IllegalArgumentException("Don't know how to run scenario.");
            }
            if (settings.isBenchmark()) {
                benchmarkResults.write(settings);
            }
            if (settings.isGenerateDiffs() && scenarios.size() > 1) {
                List<Stacks> stacks = new DifferentialStacksGenerator().generateDifferentialStacks(settings.getOutputDir());
                new FlameGraphGenerator().generateDifferentialGraphs(stacks);
            }
            System.out.println();
            System.out.println("* Results written to " + settings.getOutputDir().getAbsolutePath());
            Main.printResultFileSummaries(settings.getOutputDir(), settings.getProfiler());
            this.printReportSummary(settings, benchmarkResults);
            if (!failures.isEmpty()) {
                throw new ScenarioFailedException((Throwable)failures.get(0));
            }
        }
        catch (CommandLineParser.SettingsNotAvailableException | ScenarioFailedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw e;
        }
        finally {
            System.out.println();
            System.out.flush();
        }
    }

    private static void printScenariosConfigDump(InvocationSettings settings) {
        if (settings.getScenarioFile() == null) {
            System.err.println("--dump-scenarios requires a scenario file (--scenario-file)");
            throw new IllegalArgumentException("--dump-scenarios requires a scenario file");
        }
        String output = ScenarioLoader.dumpScenarios(settings.getScenarioFile(), settings);
        System.out.print(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends ScenarioDefinition, R extends BuildInvocationResult> void invoke(ScenarioInvoker<S, R> invoker, S scenario, InvocationSettings settings, BenchmarkResultCollector benchmarkResults, List<Throwable> failures) throws IOException {
        try {
            SampleProvider<R> sampleProvider = invoker.samplesFor(settings, scenario);
            Consumer<R> resultConsumer = benchmarkResults.scenario(scenario, sampleProvider);
            invoker.run(scenario, settings, resultConsumer);
        }
        catch (Throwable t) {
            t.printStackTrace();
            failures.add(t);
        }
        finally {
            if (settings.isBenchmark()) {
                benchmarkResults.write(settings);
            }
        }
    }

    private void printReportSummary(InvocationSettings settings, BenchmarkResultCollector benchmarkResults) {
        if (settings.isBenchmark()) {
            benchmarkResults.summarizeResults(line -> System.out.println("  " + line));
        }
    }

    private void logScenarios(List<ScenarioDefinition> scenarios) {
        Logging.startOperation("Scenarios");
        for (ScenarioDefinition scenario : scenarios) {
            scenario.printTo(System.out);
        }
    }

    private static void printResultFileSummaries(File outputDir, Profiler profiler) {
        if (outputDir == null) {
            return;
        }
        List results = Arrays.stream(outputDir.listFiles()).sorted().collect(Collectors.toList());
        for (File file : results) {
            if (!file.isFile()) continue;
            profiler.summarizeResultFile(file, line -> System.out.println("  " + line));
        }
        for (File file : results) {
            if (!file.isDirectory()) continue;
            Main.printResultFileSummaries(file, profiler);
        }
    }

    static class ScenarioFailedException
    extends RuntimeException {
        public ScenarioFailedException(Throwable cause) {
            super(cause);
        }
    }
}

