/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.io.File;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;

public enum AsyncProfilerOutputType {
    STACKS("collapsed"){

        @Override
        File outputFileFor(ScenarioSettings settings) {
            return settings.profilerOutputLocationFor(".stacks.txt");
        }
    }
    ,
    JFR("jfr"){

        @Override
        File outputFileFor(ScenarioSettings settings) {
            return settings.computeJfrProfilerOutputLocation();
        }
    };

    private final String commandLineOption;

    public static AsyncProfilerOutputType from(AsyncProfilerConfig config, ScenarioDefinition scenarioDefinition) {
        return config.getEvents().size() > 1 || scenarioDefinition.createsMultipleProcesses() ? JFR : STACKS;
    }

    private AsyncProfilerOutputType(String commandLineOption) {
        this.commandLineOption = commandLineOption;
    }

    abstract File outputFileFor(ScenarioSettings var1);

    File individualOutputFileFor(ScenarioSettings settings) {
        File outputFile = this.outputFileFor(settings);
        return settings.getScenario().createsMultipleProcesses() ? new File(outputFile, "profile-%t-%p.jfr") : outputFile;
    }

    public String getCommandLineOption() {
        return this.commandLineOption;
    }
}

