/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.nio.file.OpenOption;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.support.FileSupport;

public abstract class AbstractFileChangeMutator
implements BuildMutator {
    protected final File sourceFile;
    private final String changeDescription;
    private String originalText;

    protected AbstractFileChangeMutator(File sourceFile, String changeDescription) {
        this.sourceFile = sourceFile;
        this.changeDescription = changeDescription;
    }

    protected AbstractFileChangeMutator(File sourceFile) {
        this(sourceFile, "change");
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        this.originalText = this.readText(this.sourceFile);
    }

    @Override
    public void beforeBuild(BuildContext context) {
        System.out.printf("> Applying %s to '%s'%n", this.changeDescription, this.sourceFile);
        StringBuilder modifiedText = new StringBuilder(this.originalText);
        this.applyChangeTo(context, modifiedText);
        FileSupport.writeUnchecked(this.sourceFile.toPath(), modifiedText.toString(), new OpenOption[0]);
    }

    private String readText(File file) {
        return FileSupport.readUnchecked(file.toPath());
    }

    protected abstract void applyChangeTo(BuildContext var1, StringBuilder var2);

    @Override
    public void afterScenario(ScenarioContext context) {
        this.revert(this.sourceFile, this.originalText);
    }

    protected void revert(File file, String originalText) {
        FileSupport.writeUnchecked(file.toPath(), originalText, new OpenOption[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.sourceFile + ')';
    }
}

