/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.File;
import java.util.List;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractJavaSourceFileMutator;

public class ApplyAbiChangeToJavaSourceFileMutator
extends AbstractJavaSourceFileMutator {
    public ApplyAbiChangeToJavaSourceFileMutator(File sourceFile) {
        super(sourceFile, "ABI change");
    }

    @Override
    protected void applyChangeTo(BuildContext context, CompilationUnit compilationUnit) {
        NodeList types = compilationUnit.getTypes();
        if (types.isEmpty()) {
            throw new IllegalArgumentException("No types to change in " + this.sourceFile);
        }
        TypeDeclaration type = (TypeDeclaration)types.get(0);
        List methods = type.getMethods();
        if (methods.isEmpty()) {
            throw new IllegalArgumentException("No methods to change in " + this.sourceFile);
        }
        String newMethodName = "_m" + context.getUniqueBuildId();
        MethodDeclaration existingMethod = (MethodDeclaration)methods.get(0);
        ((BlockStmt)existingMethod.getBody().get()).addStatement(0, (Expression)new MethodCallExpr(null, newMethodName));
        type.addMethod(newMethodName, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
    }
}

