/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class ClearConfigurationCacheStateMutator
extends AbstractScheduledMutator {
    private final File projectDir;

    public ClearConfigurationCacheStateMutator(File projectDir, AbstractScheduledMutator.Schedule schedule) {
        super(schedule);
        this.projectDir = projectDir;
    }

    @Override
    public void validate(BuildInvoker invoker) {
    }

    @Override
    protected void executeOnSchedule() {
        System.out.println("> Cleaning configuration cache state");
        this.cleanup(new File(this.projectDir, ".gradle/configuration-cache"));
        this.cleanup(new File(this.projectDir, ".instant-execution-state"));
    }

    private void cleanup(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractScheduledMutator.Configurator {
        @Override
        protected BuildMutator newInstance(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, String key, AbstractScheduledMutator.Schedule schedule) {
            return new ClearConfigurationCacheStateMutator(spec.getProjectDir(), schedule);
        }
    }
}

