/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.BinaryScaleFactor;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.DecimalUnitSelector;
import org.openjdk.jmc.common.unit.DisplayFormatter;
import org.openjdk.jmc.common.unit.IFormatter;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.ImpreciseScaleFactor;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.LongScaleFactor;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.ScalarQuantity;
import org.openjdk.jmc.common.unit.ScaleFactor;
import org.openjdk.jmc.common.unit.TypedUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatThreadLocal;

public class LinearKindOfQuantity
extends KindOfQuantity<LinearUnit> {
    private static final FormatThreadLocal<NumberFormat> NUMBER_FORMAT_INTERACTIVE_HOLDER;
    private static final FormatThreadLocal<NumberFormat> NUMBER_FORMAT_DISPLAY_HOLDER;
    protected final LinearUnit atomUnit;
    protected final String atomUnitName;
    protected final Collection<LinearUnit> commonUnits = new TreeSet<LinearUnit>();
    protected final Collection<LinearUnit> allUnits = new TreeSet<LinearUnit>();
    protected final Map<String, LinearUnit> interactiveSymbolToUnitMap = new HashMap<String, LinearUnit>();
    protected LinearUnitSelector unitSelector;
    protected final Map<Object, LinearUnit> unitCache = new HashMap<Object, LinearUnit>();
    private static final Pattern NUMBER_UNIT_PATTERN;

    public static NumberFormat getNumberFormat(boolean interactive) {
        return interactive ? (NumberFormat)NUMBER_FORMAT_INTERACTIVE_HOLDER.get() : (NumberFormat)NUMBER_FORMAT_DISPLAY_HOLDER.get();
    }

    public LinearKindOfQuantity(String id, String atomUnitId) {
        this(id, atomUnitId, EnumSet.of(DecimalPrefix.NONE));
    }

    public <P extends Enum<P>> LinearKindOfQuantity(String id, String atomUnitId, P minPrefix, P maxPrefix) {
        this(id, atomUnitId, EnumSet.range(minPrefix, maxPrefix));
    }

    <P extends IPrefix<P>> LinearKindOfQuantity(String id, String atomUnitId, Collection<P> prefixes) {
        this(id, atomUnitId, prefixes, prefixes);
    }

    <P extends IPrefix<P>> LinearKindOfQuantity(String id, String atomUnitId, Collection<P> commonPrefixes, Collection<P> allPrefixes) {
        super(id);
        String unitSymbol = this.resolveLocalizedSymbol(DecimalPrefix.NONE, atomUnitId, atomUnitId);
        this.atomUnitName = this.resolveLocalizedName(DecimalPrefix.NONE, atomUnitId, null);
        String appendableUnitSymbol = unitSymbol.length() == 0 ? "" : "\u00a0" + unitSymbol;
        this.atomUnit = this.atomUnitName != null ? new LinearUnit(this, atomUnitId, DecimalScaleFactor.get(0), unitSymbol, "1" + appendableUnitSymbol + " (= 1\u00a0" + this.atomUnitName + ')', this.atomUnitName) : new LinearUnit(this, atomUnitId, DecimalScaleFactor.get(0), unitSymbol, "1" + appendableUnitSymbol, new String[0]);
        for (IPrefix prefix : allPrefixes) {
            LinearUnit unit = this.getUnit(prefix);
            this.addUnit(unit, commonPrefixes.contains(prefix));
        }
        if (allPrefixes.isEmpty()) {
            this.unitSelector = new DecimalUnitSelector(this, this.atomUnit);
        } else {
            IPrefix anyPrefix = (IPrefix)allPrefixes.iterator().next();
            this.unitSelector = anyPrefix.createUnitSelector(this, allPrefixes);
        }
    }

    protected void setDefaultSelector(LinearUnitSelector unitSelector) {
        this.unitSelector = unitSelector;
    }

    @Override
    public KindOfQuantity<LinearUnit> getDeltaKind() {
        return this;
    }

    @Override
    public LinearUnit getDefaultUnit() {
        return this.atomUnit;
    }

    protected String resolveLocalizedName(IPrefix<?> prefix) {
        return this.resolveLocalizedName(prefix, this.atomUnit.getIdentifier(), this.atomUnitName);
    }

    protected String resolveLocalizedSymbol(IPrefix<?> prefix) {
        return this.resolveLocalizedSymbol(prefix, this.atomUnit.getIdentifier(), this.atomUnit.getLocalizedSymbol());
    }

    public LinearUnit getUnit(IPrefix<?> prefix) {
        LinearUnit unit = this.getCachedUnit(prefix);
        if (unit == null) {
            if (prefix.scaleFactor().isUnity()) {
                this.unitCache.put(prefix, this.atomUnit);
                return this.atomUnit;
            }
            String id = prefix.identifier() + this.atomUnit.getIdentifier();
            String symbol = this.resolveLocalizedSymbol(prefix);
            String name = this.resolveLocalizedName(prefix);
            StringBuilder descBuf = new StringBuilder("1\u00a0");
            descBuf.append(symbol);
            if (name != null) {
                descBuf.append(" (= 1\u00a0");
                descBuf.append(name);
                descBuf.append(" = ");
            } else {
                descBuf.append(" (= ");
            }
            descBuf.append((CharSequence)prefix.asExponentialStringBuilder(false));
            descBuf.append(this.atomUnit.getAppendableSuffix(false));
            if (prefix instanceof BinaryPrefix) {
                BinaryPrefix binPrefix = (BinaryPrefix)prefix;
                DecimalPrefix prefixSI = binPrefix.prefixSI;
                String altSymbol = this.resolveLocalizedSymbol(prefixSI);
                String altName = this.resolveLocalizedName(prefixSI);
                descBuf.append(" \u2248 1\u00a0");
                descBuf.append(altSymbol);
                if (altName != null) {
                    descBuf.append(" = 1\u00a0");
                    descBuf.append(altName);
                }
                descBuf.append(" = ");
                descBuf.append((CharSequence)prefixSI.asExponentialStringBuilder(false));
                descBuf.append(this.atomUnit.getAppendableSuffix(false));
                descBuf.append(')');
                unit = altName != null ? new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol, altName) : new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol);
            } else if (prefix.altSymbol() != null) {
                String altSymbol = prefix.altSymbol() + this.atomUnit.getLocalizedSymbol();
                descBuf.append(')');
                unit = new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol);
            } else {
                descBuf.append(')');
                unit = new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name);
            }
            this.unitCache.put(prefix, unit);
        }
        return unit;
    }

    @Override
    public LinearUnit getUnit(String id) {
        return (LinearUnit)super.getUnit(id);
    }

    public LinearUnit getCachedUnit(Object key) {
        return this.unitCache.get(key);
    }

    protected ScaleFactor getBestScaleFactorFor(long value) {
        int log2 = BinaryPrefix.getFloorLog2(value);
        if ((long)(1 << log2) == value) {
            return BinaryScaleFactor.get(log2);
        }
        DecimalScaleFactor factor = DecimalScaleFactor.getSciFloorFactor(value);
        long mult = (long)factor.getMultiplier();
        if (mult == value) {
            return factor;
        }
        return new LongScaleFactor(value);
    }

    public LinearUnit makeUnit(String id, ITypedQuantity<LinearUnit> quantity) {
        return this.makeUnit(id, id, quantity, null, false);
    }

    public LinearUnit makeUnit(String id, ITypedQuantity<LinearUnit> quantity, String localizedName) {
        return this.makeUnit(id, id, quantity, localizedName, false);
    }

    public LinearUnit makeCustomUnit(ITypedQuantity<LinearUnit> quantity) {
        if (quantity instanceof ScalarQuantity.LongStored && quantity.longValue() == 1L) {
            return (LinearUnit)quantity.getUnit();
        }
        String id = quantity.persistableString();
        String symbol = "\u00d7" + quantity.localizedFormat(false, false);
        return this.makeUnit(id, symbol, quantity, null, true);
    }

    private LinearUnit makeUnit(String id, String localizedSymbol, ITypedQuantity<LinearUnit> quantity, String localizedName, boolean custom) {
        LinearUnit oldUnit;
        String[] altNames;
        ScaleFactor factorToAtom;
        ScaleFactor factorToDefinition;
        String relStr;
        String symbol = this.resolveLocalizedSymbol(DecimalPrefix.NONE, id, localizedSymbol);
        String name = this.resolveLocalizedName(DecimalPrefix.NONE, id, localizedName);
        boolean isFactor = symbol.startsWith("\u00d7");
        StringBuilder descBuf = new StringBuilder();
        if (!isFactor) {
            if (symbol.length() == 0) {
                descBuf.append('1');
            } else {
                descBuf.append("1\u00a0");
                descBuf.append(symbol);
            }
            if (name != null) {
                descBuf.append(" (= 1\u00a0");
                descBuf.append(name);
                descBuf.append(" = ");
            } else {
                descBuf.append(" (= ");
            }
        }
        if (quantity instanceof ScalarQuantity.LongStored) {
            descBuf.append(quantity.localizedFormat(false, false));
            relStr = " = ";
            factorToDefinition = this.getBestScaleFactorFor(quantity.longValue());
            factorToAtom = ((LinearUnit)quantity.getUnit()).valueTransformTo(this.atomUnit).concat(factorToDefinition);
        } else {
            descBuf.append(AutoFormatter.formatInUnit(quantity, (LinearUnit)quantity.getUnit(), 3));
            relStr = " \u2248 ";
            factorToDefinition = new ImpreciseScaleFactor(quantity.doubleValue());
            factorToAtom = new ImpreciseScaleFactor(quantity.doubleValueIn(this.atomUnit));
        }
        if (!this.atomUnit.equals(quantity.getUnit())) {
            descBuf.append(relStr);
            descBuf.append(AutoFormatter.formatInUnit(quantity, this.atomUnit, 3));
        }
        if (!isFactor) {
            descBuf.append(')');
        }
        if (isFactor) {
            String qStr = quantity.interactiveFormat();
            String suffix = ((LinearUnit)quantity.getUnit()).getAppendableSuffix(true);
            if (suffix.startsWith(" ")) {
                String trimmed = qStr.replace(suffix, ((LinearUnit)quantity.getUnit()).getLocalizedSymbol());
                String[] names = new String[]{"\u00d7" + qStr, "x" + qStr, "\u00d7" + trimmed, "x" + trimmed};
                altNames = names;
            } else {
                String[] names = new String[]{"\u00d7" + qStr, "x" + qStr};
                altNames = names;
            }
        } else if (name != null) {
            String[] names = new String[]{name};
            altNames = names;
        } else {
            altNames = new String[]{};
        }
        LinearUnit unit = custom ? new LinearUnit.Custom(this, id, factorToDefinition, (LinearUnit)quantity.getUnit(), symbol, descBuf.toString(), altNames) : new LinearUnit(this, id, factorToAtom, symbol, descBuf.toString(), altNames);
        if (id != null && (oldUnit = this.unitCache.put(id, unit)) != null) {
            UnitLookup.getLogger().log(Level.FINE, "Replaced cached unit " + oldUnit + " with " + unit);
        }
        return unit;
    }

    @Override
    public String toString() {
        return "Linear(" + this.m_identifier + ')';
    }

    @Override
    public LinearUnit getPreferredUnit(IQuantity quantity, double minNumericalValue, double maxNumericalValue) {
        ITypedQuantity typedQuantity = (ITypedQuantity)quantity;
        return (LinearUnit)this.unitSelector.getPreferredUnit(typedQuantity, minNumericalValue, maxNumericalValue);
    }

    @Override
    public LinearUnit getLargestExactUnit(IQuantity quantity) {
        ITypedQuantity typedQuantity = (ITypedQuantity)quantity;
        return (LinearUnit)this.unitSelector.getLargestExactUnit(typedQuantity);
    }

    public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> upperLimit) {
        return this.unitSelector.snapToBestBetweenHalfAndEqual(upperLimit);
    }

    @Override
    public IFormatter<IQuantity> getFormatterResolving(IRange<IQuantity> range) {
        return this.getFormatter("auto");
    }

    @Override
    public ITypedQuantity<LinearUnit> parsePersisted(String persistedQuantity) throws QuantityConversionException {
        Matcher m = NUMBER_UNIT_PATTERN.matcher(persistedQuantity.trim());
        if (m.matches()) {
            LinearUnit unit = this.getUnit(m.group(3));
            if (unit != null) {
                try {
                    if (m.group(2).length() == 0) {
                        return unit.quantity(Long.parseLong(m.group(1)));
                    }
                    return unit.quantity(Double.parseDouble(m.group(1) + m.group(2)));
                }
                catch (RuntimeException runtimeException) {}
            } else {
                if (m.group(3).length() == 0) {
                    throw QuantityConversionException.noUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
                }
                throw QuantityConversionException.unknownUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
            }
        }
        throw QuantityConversionException.unparsable(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    @Override
    public Collection<LinearUnit> getAllUnits() {
        return this.allUnits;
    }

    @Override
    public Collection<LinearUnit> getCommonUnits() {
        return this.commonUnits;
    }

    @Override
    protected void addUnit(LinearUnit unit) {
        this.addUnit(unit, true);
    }

    protected void addUnit(LinearUnit unit, boolean common) {
        super.addUnit(unit);
        this.allUnits.add(unit);
        if (common) {
            this.commonUnits.add(unit);
        }
        this.interactiveSymbolToUnitMap.put(unit.getIdentifier(), unit);
        this.interactiveSymbolToUnitMap.put(unit.getLocalizedSymbol().replace('\u00a0', ' '), unit);
    }

    @Override
    public ITypedQuantity<LinearUnit> parseInteractive(String interactiveQuantity) throws QuantityConversionException {
        return this.parseInteractive(interactiveQuantity, null);
    }

    public ITypedQuantity<LinearUnit> parseInteractive(String interactiveQuantity, Map<String, ? extends LinearUnit> symbolToUnitMap) throws QuantityConversionException {
        interactiveQuantity = interactiveQuantity.replace('\u00a0', ' ');
        Number num = null;
        ParsePosition pos = null;
        if (this.isHexString(interactiveQuantity)) {
            String numberString = LinearKindOfQuantity.getHexNumberString(interactiveQuantity);
            pos = new ParsePosition(2 + numberString.length());
            num = this.parseHexNumberString(numberString);
        } else {
            NumberFormat formatter = (NumberFormat)NUMBER_FORMAT_INTERACTIVE_HOLDER.get();
            pos = new ParsePosition(0);
            num = formatter.parse(interactiveQuantity, pos);
        }
        if (num != null) {
            String rest = interactiveQuantity.substring(pos.getIndex()).trim();
            LinearUnit unit = this.interactiveSymbolToUnitMap.get(rest);
            if (unit == null && symbolToUnitMap != null) {
                unit = symbolToUnitMap.get(rest);
            }
            if (unit == null) {
                if (rest.length() == 0) {
                    throw QuantityConversionException.noUnit(interactiveQuantity, this.getDefaultUnit().quantity(num));
                }
                if (rest.contains(" ") && !rest.startsWith("\u00d7")) {
                    throw QuantityConversionException.unparsable(rest, this.getDefaultUnit().quantity(num));
                }
                throw QuantityConversionException.unknownUnit(rest, this.getDefaultUnit().quantity(num));
            }
            return unit.quantity(num);
        }
        throw QuantityConversionException.unparsable(interactiveQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    private boolean isHexString(String interactiveQuantity) {
        return interactiveQuantity.startsWith("0x") || interactiveQuantity.startsWith("0X");
    }

    private Number parseHexNumberString(String numberString) throws QuantityConversionException {
        try {
            return Long.parseLong(numberString, 16);
        }
        catch (NumberFormatException e) {
            throw QuantityConversionException.unparsable(numberString, this.getDefaultUnit().quantity(6844L));
        }
    }

    private static String getHexNumberString(String interactiveQuantity) {
        int i;
        for (i = 2; i < interactiveQuantity.length() && LinearKindOfQuantity.isHexDigit(interactiveQuantity.charAt(i)); ++i) {
        }
        return interactiveQuantity.substring(2, i);
    }

    private static boolean isHexDigit(char character) {
        return character >= '0' && character <= '9' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f';
    }

    static {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMaximumFractionDigits(340);
        NUMBER_FORMAT_DISPLAY_HOLDER = new FormatThreadLocal<NumberFormat>(formatter);
        if (formatter instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = ((DecimalFormat)formatter).getDecimalFormatSymbols();
            if (symbols.getGroupingSeparator() == '\u00a0') {
                symbols.setGroupingSeparator(' ');
            }
            ((DecimalFormat)formatter).setDecimalFormatSymbols(symbols);
        }
        NUMBER_FORMAT_INTERACTIVE_HOLDER = new FormatThreadLocal<NumberFormat>(formatter);
        NUMBER_UNIT_PATTERN = Pattern.compile("^(-?\\d+)(\\.?\\d*(?:E-?\\d+)?)\\s*([a-zA-Z%]*)$");
    }

    public static class DualUnitFormatter
    extends DisplayFormatter<IQuantity> {
        private static final double PRECISION_LIMIT = Double.longBitsToDouble(4427038433705197568L);
        private final TypedUnit.UnitSelector<LinearUnit> unitSelector;
        private final LinearUnit cutoffUnit;

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name) {
            this(kindOfQuantity, id, name, null, null);
        }

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, LinearUnit cutoffUnit) {
            this(kindOfQuantity, id, name, null, cutoffUnit);
        }

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, TypedUnit.UnitSelector<LinearUnit> unitSelector) {
            this(kindOfQuantity, id, name, unitSelector, null);
        }

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, TypedUnit.UnitSelector<LinearUnit> unitSelector, LinearUnit cutoffUnit) {
            super(kindOfQuantity, id, name);
            this.unitSelector = unitSelector;
            this.cutoffUnit = cutoffUnit;
        }

        private TypedUnit.UnitSelector<LinearUnit> getSelector() {
            return this.unitSelector != null ? this.unitSelector : ((LinearKindOfQuantity)this.getContentType()).unitSelector;
        }

        @Override
        public String format(IQuantity quantity) {
            double valueInBigs;
            ITypedQuantity typedQuantity = (ITypedQuantity)quantity;
            TypedUnit.UnitSelector<LinearUnit> selector = this.getSelector();
            LinearUnit bigUnit = selector.getPreferredUnit(typedQuantity, 1.0, 1000.0);
            if (bigUnit.getIdentifier() == null) {
                return AutoFormatter.formatInUnit(quantity, bigUnit, 3);
            }
            double bigs = (valueInBigs = quantity.doubleValueIn(bigUnit)) < 0.0 ? Math.ceil(valueInBigs) : Math.floor(valueInBigs);
            double absRest = Math.abs(valueInBigs - bigs);
            if (absRest < PRECISION_LIMIT || absRest > 1.0 - PRECISION_LIMIT) {
                return AutoFormatter.formatWithUnit(valueInBigs, bigUnit, 3);
            }
            IQuantity restQuantity = bigUnit.quantity(absRest);
            LinearUnit smallUnit = selector.getPreferredUnit((ITypedQuantity<LinearUnit>)restQuantity, 1.0, 1000.0);
            if (this.cutoffUnit != null && smallUnit.compareTo(this.cutoffUnit) < 0) {
                return AutoFormatter.formatWithUnit(valueInBigs, bigUnit, 0);
            }
            if (smallUnit.getIdentifier() == null || smallUnit.equals(bigUnit)) {
                return AutoFormatter.formatWithUnit(valueInBigs, bigUnit, 3);
            }
            ScaleFactor scale = bigUnit.valueTransformTo(smallUnit);
            if (scale instanceof DecimalScaleFactor) {
                return AutoFormatter.formatWithFixedFraction(valueInBigs, bigUnit, 3);
            }
            double smalls = Math.round(restQuantity.doubleValueIn(smallUnit));
            if (smallUnit.valueTransformTo(bigUnit).targetValue(smalls) >= 1.0) {
                return AutoFormatter.formatWithUnit(bigs + Math.signum(bigs), bigUnit, 3);
            }
            return AutoFormatter.formatWithUnit(bigs, bigUnit, 3) + '\u00a0' + AutoFormatter.formatWithUnit(smalls, smallUnit, 3);
        }
    }

    public static class AutoFormatter
    extends DisplayFormatter<IQuantity> {
        protected final double minNumericalValue;
        protected final double maxNumericalValue;
        protected final int nominalValueDigits;

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String name) {
            this(kindOfQuantity, "auto", name, 1.0, 1000.0, 3);
        }

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String name, double minNumericalValue, double maxNumericalValue) {
            this(kindOfQuantity, "auto", name, minNumericalValue, maxNumericalValue, 3);
        }

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, double minNumericalValue, double maxNumericalValue, int nominalValueDigits) {
            super(kindOfQuantity, id, name);
            this.minNumericalValue = minNumericalValue;
            this.maxNumericalValue = maxNumericalValue;
            this.nominalValueDigits = nominalValueDigits;
        }

        public LinearKindOfQuantity getContentType() {
            return (LinearKindOfQuantity)super.getContentType();
        }

        @Override
        public String format(IQuantity quantity) {
            LinearUnit preferredUnit = this.getContentType().getPreferredUnit(quantity, this.minNumericalValue, this.maxNumericalValue);
            return AutoFormatter.formatInUnit(quantity, preferredUnit, this.nominalValueDigits);
        }

        public static String formatInUnit(IQuantity quantity, LinearUnit customUnit, int nominalValueDigits) {
            return AutoFormatter.formatWithUnit(quantity.numberValueIn(customUnit), customUnit, nominalValueDigits);
        }

        protected static String formatWithUnit(Number numValue, LinearUnit customUnit, int nominalValueDigits) {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            int intDigits = DecimalPrefix.getFloorLog10(numValue.doubleValue()) + 1;
            formatter.setMaximumFractionDigits(nominalValueDigits - intDigits);
            return formatter.format(numValue) + customUnit.getAppendableSuffix(false);
        }

        protected static String formatWithFixedFraction(Number numValue, LinearUnit customUnit, int numFractionDigits) {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMinimumFractionDigits(numFractionDigits);
            formatter.setMaximumFractionDigits(numFractionDigits);
            return formatter.format(numValue) + customUnit.getAppendableSuffix(false);
        }
    }

    public static interface LinearUnitSelector
    extends TypedUnit.UnitSelector<LinearUnit> {
        public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> var1);
    }
}

