/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.util.List;
import java.util.Locale;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

class AsyncProfilerJvmArgsCalculator
implements JvmArgsCalculator {
    private final AsyncProfilerConfig profilerConfig;
    private final ScenarioSettings scenarioSettings;
    private final AsyncProfilerOutputType outputType;

    AsyncProfilerJvmArgsCalculator(AsyncProfilerConfig profilerConfig, ScenarioSettings scenarioSettings) {
        this.profilerConfig = profilerConfig;
        this.scenarioSettings = scenarioSettings;
        this.outputType = AsyncProfilerOutputType.from(profilerConfig, scenarioSettings.getScenario());
    }

    @Override
    public void calculateJvmArgs(List<String> jvmArgs) {
        StringBuilder agent = new StringBuilder().append("-agentpath:").append(this.profilerConfig.getProfilerHome()).append("/build/libasyncProfiler.so=start").append(",event=").append(this.profilerConfig.getJoinedEvents()).append(",interval=").append(this.profilerConfig.getInterval()).append(",jstackdepth=").append(this.profilerConfig.getStackDepth()).append(",").append(this.outputType.getCommandLineOption()).append(",").append(this.profilerConfig.getCounter().name().toLowerCase(Locale.ROOT)).append(",file=").append(this.outputType.individualOutputFileFor(this.scenarioSettings)).append(",ann");
        if (this.profilerConfig.getEvents().contains("alloc")) {
            agent.append(",alloc=").append(this.profilerConfig.getAllocSampleSize());
        }
        if (this.profilerConfig.getEvents().contains("lock")) {
            agent.append(",lock=").append(this.profilerConfig.getLockThreshold());
        }
        jvmArgs.add(agent.toString());
    }
}

