/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.buildscan;

import java.io.PrintWriter;
import org.gradle.profiler.GeneratedInitScript;

public class BuildScanInitScript
extends GeneratedInitScript {
    private final String version;

    public BuildScanInitScript(String version) {
        this.version = version;
    }

    @Override
    public void writeContents(PrintWriter writer) {
        writer.write("initscript {\n");
        writer.write("    repositories {\n");
        writer.write("      maven {\n");
        writer.write("          url \"https://plugins.gradle.org/m2\"\n");
        writer.write("        }\n");
        writer.write("    }\n");
        writer.write("    dependencies {\n");
        writer.write("        classpath \"com.gradle:build-scan-plugin:" + this.version + "\"\n");
        writer.write("    }\n");
        writer.write("}\n");
        writer.write("\n");
        writer.write("rootProject { prj ->\n");
        writer.write("    apply plugin: initscript.classLoader.loadClass(\"com.gradle.scan.plugin.BuildScanPlugin\")\n");
        writer.write("    buildScan {\n");
        if (this.version.startsWith("0.") || this.version.startsWith("1.")) {
            writer.write("        licenseAgreementUrl = 'https://gradle.com/terms-of-service'\n");
            writer.write("        licenseAgree = 'yes'\n");
        } else {
            writer.write("        termsOfServiceUrl = 'https://gradle.com/terms-of-service'\n");
            writer.write("        termsOfServiceAgree = 'yes'\n");
        }
        writer.write("    }\n");
        writer.write("}\n");
    }
}

