/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.buildscan;

import java.io.PrintWriter;
import org.gradle.profiler.GeneratedInitScript;

public class DevelocityInitScript
extends GeneratedInitScript {
    static final String PUBLISH_AND_TAG = "        background {\n            publishing {\n                onlyIf { System.getProperty('org.gradle.profiler.phase') == 'MEASURE' }\n            }\n        }\n        tag('GRADLE_PROFILER')\n";
    private final String version;

    public DevelocityInitScript(String version) {
        this.version = version;
    }

    @Override
    public void writeContents(PrintWriter writer) {
        writer.write("initscript {\n");
        writer.write("    repositories {\n");
        writer.write("      gradlePluginPortal()\n");
        writer.write("    }\n");
        writer.write("    dependencies {\n");
        writer.write("        classpath(\"com.gradle.develocity:com.gradle.develocity.gradle.plugin:" + this.version + "\")\n");
        writer.write("    }\n");
        writer.write("}\n");
        writer.write("\n");
        writer.write("settingsEvaluated {\n");
        writer.write("    if (!it.pluginManager.hasPlugin(\"com.gradle.develocity\")) {\n");
        writer.write("        it.pluginManager.apply(com.gradle.develocity.agent.gradle.DevelocityPlugin)\n");
        writer.write("    }\n");
        writer.write("    it.extensions[\"develocity\"].buildScan.with {\n");
        writer.write("        termsOfUseUrl = 'https://gradle.com/help/legal-terms-of-use'\n");
        writer.write("        termsOfUseAgree = 'yes'\n");
        writer.write(PUBLISH_AND_TAG);
        writer.write("    }\n");
        writer.write("}\n");
    }
}

