/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jprofiler;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.jprofiler.JProfilerConfig;
import org.gradle.profiler.jprofiler.JProfilerController;
import org.gradle.profiler.jprofiler.JProfilerJvmArgsCalculator;

public class JProfilerProfiler
extends InstrumentingProfiler {
    private final JProfilerConfig jProfilerConfig;

    JProfilerProfiler(JProfilerConfig jProfilerConfig) {
        this.jProfilerConfig = jProfilerConfig;
    }

    public String toString() {
        return "JProfiler";
    }

    @Override
    public void summarizeResultFile(File resultFile, Consumer<String> consumer) {
        if (resultFile.getName().endsWith(".jps")) {
            consumer.accept(resultFile.getAbsolutePath());
        }
    }

    @Override
    protected boolean canRestartRecording(ScenarioSettings settings) {
        return true;
    }

    @Override
    public InstrumentingProfiler.SnapshotCapturingProfilerController newSnapshottingController(ScenarioSettings settings) {
        return new JProfilerController(settings, this.jProfilerConfig);
    }

    @Override
    protected JvmArgsCalculator jvmArgsWithInstrumentation(ScenarioSettings settings, boolean startRecordingOnProcessStart, boolean captureSnapshotOnProcessExit) {
        return new JProfilerJvmArgsCalculator(this.jProfilerConfig, settings, startRecordingOnProcessStart, captureSnapshotOnProcessExit);
    }
}

