/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;

public abstract class AbstractJavaSourceFileMutator
extends AbstractFileChangeMutator {
    public AbstractJavaSourceFileMutator(File sourceFile, String changeDescription) {
        super(sourceFile, changeDescription);
        if (!sourceFile.getName().endsWith(".java")) {
            throw new IllegalArgumentException("Can only modify Java source files");
        }
    }

    @Override
    protected void applyChangeTo(BuildContext context, StringBuilder text) {
        CompilationUnit compilationUnit = (CompilationUnit)new JavaParser().parse(text.toString()).getResult().get();
        this.applyChangeTo(context, compilationUnit);
        text.replace(0, text.length(), compilationUnit.toString());
    }

    protected abstract void applyChangeTo(BuildContext var1, CompilationUnit var2);
}

