/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import org.gradle.profiler.mutations.AbstractDelegateFileMutator;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;
import org.gradle.profiler.mutations.ApplyAbiChangeToJavaSourceFileMutator;
import org.gradle.profiler.mutations.ApplyAbiChangeToKotlinSourceFileMutator;

public class ApplyAbiChangeToSourceFileMutator
extends AbstractDelegateFileMutator {
    public ApplyAbiChangeToSourceFileMutator(File sourceFile) {
        super(sourceFile, "ABI change");
    }

    @Override
    protected AbstractFileChangeMutator getFileChangeMutator(File sourceFile) {
        if (sourceFile.getName().endsWith(".kt")) {
            return new ApplyAbiChangeToKotlinSourceFileMutator(sourceFile);
        }
        if (sourceFile.getName().endsWith(".java")) {
            return new ApplyAbiChangeToJavaSourceFileMutator(sourceFile);
        }
        throw new IllegalArgumentException("Can only modify Java or Kotlin source files");
    }
}

