/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;

public class ApplyChangeToNativeSourceFileMutator
extends AbstractFileChangeMutator {
    private static final List<String> nativeSourcecodeFileEndings = Arrays.asList("c", "cc", "cp", "cxx", "cpp", "c++");
    private static final List<String> nativeHeaderFileEndings = Arrays.asList("h", "hh", "hp", "hxx", "hpp", "h++", "tcc");

    public ApplyChangeToNativeSourceFileMutator(File file) {
        super(file, "native source file change");
        boolean isSupportedExtension;
        String fileExtension = this.getSourceFileExtension();
        boolean bl = isSupportedExtension = nativeSourcecodeFileEndings.contains(fileExtension) || nativeHeaderFileEndings.contains(fileExtension);
        if (isSupportedExtension) {
            return;
        }
        throw new IllegalArgumentException("Can only modify C/C++ source or header files");
    }

    @Override
    protected void applyChangeTo(BuildContext context, StringBuilder text) {
        if (nativeSourcecodeFileEndings.contains(this.getSourceFileExtension())) {
            int insertPos = text.length();
            this.applyChangeAt(context, text, insertPos);
        } else {
            int insertPos = text.lastIndexOf("#endif");
            if (insertPos < 0) {
                throw new IllegalArgumentException("Cannot parse header file " + this.sourceFile + " to apply changes");
            }
            this.applyHeaderChangeAt(context, text, insertPos);
        }
    }

    private String getSourceFileExtension() {
        return FilenameUtils.getExtension((String)this.sourceFile.getName()).toLowerCase(Locale.US);
    }

    protected String getFieldName(BuildContext context) {
        return "_m" + context.getUniqueBuildId();
    }

    private void applyChangeAt(BuildContext context, StringBuilder text, int insertPos) {
        text.insert(insertPos, "\nint " + this.getFieldName(context) + " () { }");
    }

    private void applyHeaderChangeAt(BuildContext context, StringBuilder text, int insertPos) {
        text.insert(insertPos, "int " + this.getFieldName(context) + "();\n");
    }
}

