/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.mutations.AbstractCacheCleanupMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class ClearBuildCacheMutator
extends AbstractCacheCleanupMutator {
    public ClearBuildCacheMutator(File gradleUserHome, AbstractScheduledMutator.Schedule schedule) {
        super(gradleUserHome, schedule, "build-cache-");
    }

    @Override
    protected void cleanupCacheDir(File cacheDir) {
        Arrays.stream((Object[])Objects.requireNonNull(cacheDir.listFiles(ClearBuildCacheMutator::shouldRemoveFile))).forEach(AbstractScheduledMutator::deleteFileOrDirectory);
    }

    private static boolean shouldRemoveFile(File file) {
        return file.getName().length() == 32 || file.getName().endsWith(".db");
    }

    public static class Configurator
    extends AbstractScheduledMutator.Configurator {
        @Override
        protected BuildMutator newInstance(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, String key, AbstractScheduledMutator.Schedule schedule) {
            return new ClearBuildCacheMutator(spec.getGradleUserHome(), schedule);
        }
    }
}

