/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.time.Clock;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.internal.ConsumerOperationDescriptor;
import org.gradle.tooling.events.internal.DefaultFinishEvent;
import org.gradle.tooling.events.internal.DefaultOperationFailureResult;
import org.gradle.tooling.events.internal.DefaultOperationSuccessResult;
import org.gradle.tooling.events.internal.DefaultStartEvent;
import org.gradle.tooling.events.internal.DefaultStatusEvent;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.DownloadProgressListener;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;

public class DistributionInstaller {
    private static final String APP_NAME = "Gradle Tooling API";
    private static final InternalBuildProgressListener NO_OP = new NoOpListener();
    private final ProgressLoggerFactory progressLoggerFactory;
    private final InternalBuildProgressListener buildProgressListener;
    private final Clock clock;
    private final AtomicReference<InternalBuildProgressListener> currentListener = new AtomicReference<InternalBuildProgressListener>(NO_OP);
    private final Object lock = new Object();
    private boolean completed;
    private boolean cancelled;
    private Throwable failure;

    public DistributionInstaller(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener buildProgressListener, Clock clock) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.buildProgressListener = buildProgressListener;
        this.clock = clock;
    }

    public File install(File userHomeDir, File projectDir, WrapperConfiguration wrapperConfiguration, Map<String, String> systemProperties) throws Exception {
        Install install = new Install(new Logger(false), new AsyncDownload(systemProperties), new PathAssembler(userHomeDir, projectDir));
        return install.createDist(wrapperConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = true;
            this.lock.notifyAll();
        }
    }

    private class AsyncDownload
    implements IDownload {
        private final Map<String, String> systemProperties;

        public AsyncDownload(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void download(URI address, File destination) throws Exception {
            Object object = DistributionInstaller.this.lock;
            synchronized (object) {
                this.doDownload(address, destination);
            }
        }

        private void doDownload(URI address, File destination) throws Exception {
            String displayName = "Download " + address;
            ConsumerOperationDescriptor descriptor = new ConsumerOperationDescriptor(displayName);
            long startTime = DistributionInstaller.this.clock.getCurrentTime();
            DistributionInstaller.this.buildProgressListener.onEvent(new DefaultStartEvent(startTime, displayName + " started", descriptor));
            Throwable failure = null;
            try {
                this.withProgressLogging(address, destination, descriptor);
            }
            catch (Throwable t) {
                failure = t;
            }
            long endTime = DistributionInstaller.this.clock.getCurrentTime();
            OperationResult result = failure == null ? new DefaultOperationSuccessResult(startTime, endTime) : new DefaultOperationFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable(failure)));
            DistributionInstaller.this.buildProgressListener.onEvent(new DefaultFinishEvent(endTime, displayName + " finished", descriptor, result));
            if (failure != null) {
                if (failure instanceof Exception) {
                    throw (Exception)failure;
                }
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void withProgressLogging(URI address, File destination, OperationDescriptor operationDescriptor) throws Throwable {
            ProgressLogger progressLogger = DistributionInstaller.this.progressLoggerFactory.newOperation(DistributionInstaller.class);
            progressLogger.setDescription("Download " + address);
            progressLogger.started();
            try {
                this.withAsyncDownload(address, destination, operationDescriptor);
            }
            finally {
                progressLogger.completed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void withAsyncDownload(final URI address, final File destination, final OperationDescriptor operationDescriptor) throws Throwable {
            DistributionInstaller.this.currentListener.set(DistributionInstaller.this.buildProgressListener);
            try {
                Thread thread = new Thread("Distribution download"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            new Download(new Logger(false), new ForwardingDownloadProgressListener(operationDescriptor), DistributionInstaller.APP_NAME, GradleVersion.current().getVersion(), AsyncDownload.this.systemProperties).download(address, destination);
                        }
                        catch (Throwable t) {
                            Object object = DistributionInstaller.this.lock;
                            synchronized (object) {
                                DistributionInstaller.this.failure = t;
                            }
                        }
                        finally {
                            Object object = DistributionInstaller.this.lock;
                            synchronized (object) {
                                DistributionInstaller.this.completed = true;
                                DistributionInstaller.this.lock.notifyAll();
                            }
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                Object object = DistributionInstaller.this.lock;
                synchronized (object) {
                    while (!DistributionInstaller.this.completed && !DistributionInstaller.this.cancelled) {
                        try {
                            DistributionInstaller.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            throw UncheckedException.throwAsUncheckedException(e);
                        }
                    }
                    if (DistributionInstaller.this.failure != null) {
                        throw DistributionInstaller.this.failure;
                    }
                    if (DistributionInstaller.this.cancelled) {
                        thread.interrupt();
                        throw new CancellationException();
                    }
                }
            }
            finally {
                DistributionInstaller.this.currentListener.set(NO_OP);
            }
        }
    }

    private class ForwardingDownloadProgressListener
    implements DownloadProgressListener {
        private final OperationDescriptor descriptor;

        ForwardingDownloadProgressListener(OperationDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public void downloadStatusChanged(URI address, long contentLength, long downloaded) {
            String eventDisplayName = this.descriptor.getDisplayName() + " " + downloaded + "/" + contentLength + " bytes downloaded";
            DefaultStatusEvent statusEvent = new DefaultStatusEvent(DistributionInstaller.this.clock.getCurrentTime(), eventDisplayName, this.descriptor, contentLength, downloaded, "bytes");
            ((InternalBuildProgressListener)DistributionInstaller.this.currentListener.get()).onEvent(statusEvent);
        }
    }

    private static class NoOpListener
    implements InternalBuildProgressListener {
        private NoOpListener() {
        }

        @Override
        public void onEvent(Object event) {
        }

        @Override
        public List<String> getSubscribedOperations() {
            return Collections.emptyList();
        }
    }
}

