/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.invoker;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioInvoker;
import org.gradle.profiler.gradle.GradleBuildInvocationResult;
import org.gradle.profiler.gradle.GradleScenarioInvoker;
import org.gradle.profiler.result.Sample;
import org.gradle.profiler.result.SampleProvider;
import org.gradle.profiler.studio.invoker.StudioBuildInvocationResult;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;

public class StudioGradleScenarioInvoker
extends ScenarioInvoker<StudioGradleScenarioDefinition, StudioBuildInvocationResult> {
    private final GradleScenarioInvoker gradleScenarioInvoker;

    public StudioGradleScenarioInvoker(GradleScenarioInvoker gradleScenarioInvoker) {
        this.gradleScenarioInvoker = gradleScenarioInvoker;
    }

    @Override
    public SampleProvider<StudioBuildInvocationResult> samplesFor(InvocationSettings settings, StudioGradleScenarioDefinition scenario) {
        return results -> {
            SampleProvider<GradleBuildInvocationResult> gradleSampleProvider = this.gradleScenarioInvoker.samplesFor(settings, scenario);
            List<Sample<GradleBuildInvocationResult>> gradleScenarioInvokerSamples = gradleSampleProvider.get(this.toGradleBuildInvocationResults(results));
            return ImmutableList.builder().addAll(gradleScenarioInvokerSamples).addAll(this.getGradleExecutionTimeSamples(results)).add(StudioBuildInvocationResult.GRADLE_TOTAL_EXECUTION_TIME).add(StudioBuildInvocationResult.IDE_EXECUTION_TIME).build();
        };
    }

    private List<GradleBuildInvocationResult> toGradleBuildInvocationResults(List<StudioBuildInvocationResult> results) {
        return Collections.unmodifiableList(results);
    }

    private List<Sample<StudioBuildInvocationResult>> getGradleExecutionTimeSamples(List<StudioBuildInvocationResult> results) {
        int maxGradleExecutions = results.stream().mapToInt(result -> result.getActionResult().getGradleExecutionTimes().size()).max().orElse(1);
        if (maxGradleExecutions <= 1) {
            return Collections.emptyList();
        }
        return IntStream.range(0, maxGradleExecutions).mapToObj(StudioBuildInvocationResult::getGradleToolingAgentExecutionTime).collect(Collectors.toList());
    }

    @Override
    public void run(StudioGradleScenarioDefinition scenario, InvocationSettings settings, Consumer<StudioBuildInvocationResult> resultConsumer) throws IOException, InterruptedException {
        this.gradleScenarioInvoker.run(scenario, settings, (GradleBuildInvocationResult result) -> resultConsumer.accept(new StudioBuildInvocationResult((GradleBuildInvocationResult)result)));
    }
}

