/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.profiler.BuildConfiguration;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.ScenarioDefinition;

public abstract class BuildToolCommandLineScenarioDefinition
extends ScenarioDefinition {
    private final List<String> targets;
    private final File toolHome;

    public BuildToolCommandLineScenarioDefinition(String name, @Nullable String title, List<String> targets, List<BuildMutator> buildMutators, int warmUpCount, int buildCount, File outputDir, @Nullable File toolHome) {
        super(name, title, buildMutators, warmUpCount, buildCount, outputDir);
        this.targets = targets;
        this.toolHome = toolHome;
    }

    protected abstract String getExecutableName();

    protected abstract String getToolHomeEnvName();

    @Override
    protected void printDetail(PrintStream out) {
        out.println("  Targets: " + this.getTargets());
    }

    public String getExecutablePath(File projectDir) {
        String toolHomePath = this.getToolHome() == null ? System.getenv(this.getToolHomeEnvName()) : this.getToolHome().getAbsolutePath();
        return toolHomePath == null ? this.getExecutablePathWithoutToolHome(projectDir) : toolHomePath + "/bin/" + this.getExecutableName();
    }

    @OverridingMethodsMustInvokeSuper
    protected String getExecutablePathWithoutToolHome(File projectDir) {
        return this.getExecutableName();
    }

    @Override
    public String getTasksDisplayName() {
        return String.join((CharSequence)" ", this.targets);
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public File getToolHome() {
        return this.toolHome;
    }

    @Override
    public boolean createsMultipleProcesses() {
        return true;
    }

    @Override
    public boolean doesCleanup() {
        return false;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        throw new IllegalStateException("unsupported");
    }
}

