/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import joptsimple.OptionSet;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.asyncprofiler.AsyncProfiler;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerFactory;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

public class AsyncProfilerAllEventsProfilerFactory
extends AsyncProfilerFactory {
    @Override
    public Profiler createFromOptions(OptionSet parsedOptions) {
        AsyncProfilerConfig config = super.createConfig(parsedOptions);
        ImmutableList allEvents = OperatingSystem.isMacOS() ? ImmutableList.of((Object)"cpu", (Object)"alloc", (Object)"lock") : ImmutableList.of((Object)"cpu", (Object)"wall", (Object)"alloc", (Object)"lock");
        AsyncProfilerConfig overrides = new AsyncProfilerConfig(config.getDistribution(), (List<String>)allEvents, AsyncProfilerConfig.Counter.SAMPLES, config.getInterval(), config.getAllocSampleSize(), config.getLockThreshold(), config.getWallInterval(), config.getStackDepth(), config.isIncludeSystemThreads(), AsyncProfilerOutputType.JFR);
        return new AsyncProfiler(overrides);
    }

    @Override
    public String getName() {
        return "async-profiler-all";
    }
}

