/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.base.Joiner;
import java.util.List;
import org.gradle.profiler.asyncprofiler.AsyncProfilerDistribution;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

public class AsyncProfilerConfig {
    public static final String EVENT_ALLOC = "alloc";
    public static final String EVENT_LOCK = "lock";
    public static final String EVENT_WALL = "wall";
    private final AsyncProfilerDistribution asyncProfilerDistribution;
    private final List<String> events;
    private final Counter counter;
    private final int interval;
    private final int allocSampleSize;
    private final int lockThreshold;
    private final int wallInterval;
    private final int stackDepth;
    private final boolean includeSystemThreads;
    private final AsyncProfilerOutputType preferredOutputType;

    public AsyncProfilerConfig(AsyncProfilerDistribution asyncProfilerDistribution, List<String> events, Counter counter, int interval, int allocSampleSize, int lockThreshold, int wallInterval, int stackDepth, boolean includeSystemThreads, AsyncProfilerOutputType preferredOutputType) {
        this.asyncProfilerDistribution = asyncProfilerDistribution;
        this.events = events;
        this.counter = counter;
        this.interval = interval;
        this.allocSampleSize = allocSampleSize;
        this.lockThreshold = lockThreshold;
        this.wallInterval = wallInterval;
        this.stackDepth = stackDepth;
        this.includeSystemThreads = includeSystemThreads;
        this.preferredOutputType = preferredOutputType;
    }

    public AsyncProfilerDistribution getDistribution() {
        return this.asyncProfilerDistribution;
    }

    public String getJoinedEvents() {
        return Joiner.on((String)",").join(this.events);
    }

    public List<String> getEvents() {
        return this.events;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getAllocSampleSize() {
        return this.allocSampleSize;
    }

    public int getLockThreshold() {
        return this.lockThreshold;
    }

    public int getWallInterval() {
        return this.wallInterval;
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public boolean isIncludeSystemThreads() {
        return this.includeSystemThreads;
    }

    public AsyncProfilerOutputType getPreferredOutputType() {
        return this.preferredOutputType;
    }

    public static enum Counter {
        SAMPLES,
        TOTAL;

    }
}

