/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.OperatingSystem;

public class AsyncProfilerDistribution {
    private final File executable;
    private final File library;
    private final Version version;

    AsyncProfilerDistribution(File home, String source) {
        File asprofBinary = new File(home, "bin/asprof");
        if (asprofBinary.isFile()) {
            String libExtension;
            this.executable = asprofBinary;
            if (OperatingSystem.isLinuxX86()) {
                libExtension = ".so";
            } else if (OperatingSystem.isMacOS()) {
                libExtension = ".dylib";
            } else {
                throw new IllegalStateException("Unsupported operating system: " + OperatingSystem.getId());
            }
            this.library = new File(home, "lib/libasyncProfiler" + libExtension);
        } else {
            this.executable = new File(home, "profiler.sh");
            this.library = new File(home, "build/libasyncProfiler.so");
        }
        String output = new CommandExec().runAndCollectOutput(Arrays.asList(this.executable.getAbsolutePath(), "--version"));
        Matcher matcher = Pattern.compile("Async-profiler ([\\d.]+).+").matcher(output);
        if (matcher.find()) {
            this.version = new Version(matcher.group(1).trim());
            if (this.version.major < 3) {
                throw new IllegalStateException("Async-profiler version " + this.version.stringVersion + " found at " + home + ", but version 3.0 or higher is required. (source: " + source + ")");
            }
        } else {
            throw new IllegalStateException("Unknown async-profiler distribution at: " + home + " (source: " + source + ")");
        }
    }

    public File getExecutable() {
        return this.executable;
    }

    public File getLibrary() {
        return this.library;
    }

    public Version getVersion() {
        return this.version;
    }

    public static class Version
    implements Comparable<Version> {
        public final int major;
        public final int minor;
        public final String stringVersion;

        public Version(String stringVersion) {
            String[] parts = stringVersion.split("\\.");
            if (parts.length < 2) {
                throw new IllegalArgumentException("Invalid version: " + stringVersion);
            }
            try {
                this.major = Integer.parseInt(parts[0]);
                this.minor = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid version: " + stringVersion, e);
            }
            this.stringVersion = stringVersion;
        }

        @Override
        public int compareTo(Version other) {
            int majorDiff = Integer.compare(this.major, other.major);
            if (majorDiff != 0) {
                return majorDiff;
            }
            return Integer.compare(this.minor, other.minor);
        }
    }
}

